% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{rgammashift}
\alias{rgammashift}
\title{Random sample from shifted gamma distribution}
\usage{
rgammashift(n, shape, scale)
}
\arguments{
\item{n}{number of observations.}

\item{shape}{the shape parameter of gamma distribution}

\item{scale}{the scale parameter of gamma distribution
#'}
}
\value{
A vector of \code{n} values. It is equivalent to rgamma(n, shape, scale)- shape * scale.
}
\description{
This function generates random samples from shifted gamma distribution. That is, random samples are first generated from gamma distribution with shape parameter \code{shape} and scale parameter \code{scale} and then the mean of the gamma distribution, \code{shape}*\code{scale}, is subtracted from the sample.
}
\examples{
# Generate a sample of shifted gamma observations with shape parameter 4 and scale parameter 2.
set.seed(10)
rgammashift(n = 5, shape =4, scale = 2)
# It is equivalent to
set.seed(10)
rgamma(n = 5, shape=4, scale=2)- 4 * 2
}
