% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlhighFrail.R
\name{mlhighFrail}
\alias{mlhighFrail}
\title{mlhighFrail}
\usage{
mlhighFrail(
  cols,
  idSurv,
  idEvent,
  idFrail,
  dist = "gaussian",
  per = 20,
  fold = 3,
  data
)
}
\arguments{
\item{cols}{A numeric vector of column numbers indicating the features for which the log Loss functions are to be computed}

\item{idSurv}{The name of the survival time variable}

\item{idEvent}{The name of the survival event variable}

\item{idFrail}{The name of the frailty variable}

\item{dist}{The name of the frailty distribution. Options are "gamma", "gaussian" or "t", default is "gaussian"}

\item{per}{Percentage of features to be selected, default value 20}

\item{fold}{An integer denoting number of folds in cross validation, default value 3}

\item{data}{A data frame that contains the survival and covariate information for the subjects}
}
\value{
A dataframe containing desired number of features with corresponding frailty variances.
}
\description{
This function extracts  features based on minimum log-Loss function using Cox proportional hazard model as learner method on a
high dimensional survival data. For those genes, we obtain frailty variances using CoxPH.
}
\details{
Performs CoxPH frailty on high doimensional survival data

Using the Cox proportional hazard model on the given survival data, this function selects the most significant feature based on minimum logarithmic loss function. The logarithmic loss function is defined as,
\deqn{L(f,t)=-log(f(t))}
After selcting the most significant features, a Cox proportional hazard frailty model is fitted on the selected features. The CoxPH frailty model is defined as,
\deqn{\lambda(t)=\lambda 0(t)\nu exp{X'\beta}} where \eqn{\nu} is called the frailty component. The variance of the
frailty term is considered as the heterogeneity among the subjects or patients. The distribution of frailty component is considered as either Gaussian, Gamma or t distribution.
}
\examples{
\dontrun{
data(hnscc)
mlhighFrail(cols=c(10:20), idSurv="OS", idEvent="Death", idFrail="ID", dist="gaussian",
per=20, fold = 3, data=hnscc)
}
}
\references{
Sonabend, R., Kiraly, F. J., Bender, A., Bernd Bischl B. and Lang M. mlr3proba: An R Package for Machine Learning in Survival Analysis, 2021, Bioinformatics, <https://doi.org/10.1093/bioinformatics/btab039>
}
\seealso{
mlhighHet, mlhighCox
}
\author{
Atanu Bhattacharjee, Gajendra K. Vishwakarma & Souvik Banerjee
}
