% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highcharts-api-helpers.R
\name{hc_yAxis_multiples}
\alias{hc_yAxis_multiples}
\alias{hc_xAxis_multiples}
\alias{hc_zAxis_multiples}
\alias{create_axis}
\alias{create_yaxis}
\alias{hc_add_yAxis}
\title{Creating multiples yAxis t use with highcharts}
\usage{
hc_yAxis_multiples(hc, ...)

hc_xAxis_multiples(hc, ...)

hc_zAxis_multiples(hc, ...)

create_axis(
  naxis = 2,
  heights = 1,
  sep = 0.01,
  offset = 0,
  turnopposite = TRUE,
  ...
)

create_yaxis(...)

hc_add_yAxis(hc, ...)
}
\arguments{
\item{hc}{A \code{highchart} \code{htmlwidget} object.}

\item{...}{Arguments defined in \url{https://api.highcharts.com/highcharts/yAxis}.}

\item{naxis}{Number of axis an integer.}

\item{heights}{A numeric vector. This values will be normalized.}

\item{sep}{A numeric value for the separation (in percentage) for the panes.}

\item{offset}{A numeric value (in percentage).}

\item{turnopposite}{A logical value to turn the side of each axis or not.}
}
\description{
The Y axis or value axis. Normally this is the vertical axis,
though if the chart is inverted this is the horizontal axis.
Add yAxis allows to add multiple axis with a relative height between Y axis.
Based upon the \code{relative} parameter the height of each Y axis is recalculated.
Otherwise the parameters are as supported by Y axis.
}
\examples{

highchart() \%>\%
  hc_yAxis_multiples(create_axis(naxis = 2, heights = c(2, 1))) \%>\%
  hc_add_series(data = c(1, 3, 2), yAxis = 0) \%>\%
  hc_add_series(data = c(20, 40, 10), yAxis = 1)
 
highchart() \%>\%
  hc_yAxis_multiples(create_axis(naxis = 3, lineWidth = 2, title = list(text = NULL))) \%>\%
  hc_add_series(data = c(1, 3, 2)) \%>\%
  hc_add_series(data = c(20, 40, 10), type = "area", yAxis = 1) \%>\%
  hc_add_series(data = c(200, 400, 500), yAxis = 2) \%>\%
  hc_add_series(data = c(500, 300, 400), type = "areaspline", yAxis = 2)
   

# Retrieve stock data to plot.
aapl <- quantmod::getSymbols("AAPL",
  src = "yahoo",
  from = "2020-01-01",
  auto.assign = FALSE
)

# Plot prices and volume with relative height.
highchart(type = "stock") \%>\%
  hc_title(text = "AAPLE") \%>\%
  hc_add_series(aapl, yAxis = 0, showInLegend = FALSE) \%>\%
  hc_add_yAxis(nid = 1L, title = list(text = "Prices"), relative = 2) \%>\%
  hc_add_series(aapl[, "AAPL.Volume"], yAxis = 1, type = "column", showInLegend = FALSE) \%>\%
  hc_add_yAxis(nid = 2L, title = list(text = "Volume"), relative = 1)
}
