% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hchart-shorcuts.R
\name{hcparcords}
\alias{hcparcords}
\title{Shortcut to create parallel coordinates}
\usage{
hcparcords(df, ...)
}
\arguments{
\item{df}{A data frame object.}

\item{...}{Additional shared arguments for the data series
(\url{https://api.highcharts.com/highcharts/series}) for the
\code{hchar.data.frame} function.}
}
\description{
Shortcut to create parallel coordinates
}
\examples{
require(viridisLite)

n <- 15

hcparcords(head(mtcars, n), color = hex_to_rgba(magma(n), 0.5))

require(dplyr)
data(iris)
set.seed(123)

iris <- sample_n(iris, 60)

hcparcords(iris, color = colorize(iris$Species))
}
