#' The package highriskzone provides tools to determine and evaluate high-risk zones of
#' unobserved events by using point process methodology.
#'
#' @author
#' Heidi Seibold \email{Heidi.Seibold@@campus.lmu.de},
#' Monia Mahling \email{monia.mahling@@stat.uni-muenchen.de}
#' Sebastian Linne \email{Sebastian.Linne@@campus.lmu.de}
#' Felix Guenther \email{felix.guenther@@stat.uni-muenchen.de}
#' Maintainer: Felix Guenther \email{felix.guenther@@stat.uni-muenchen.de}
#' @name highriskzone-package
#' @docType package
#' @aliases package-highriskzone
#' @import spatstat fields maps
#' @title Determining high-risk zones by using spatial point process methodology
#' @keywords package
#' @references Monia Mahling, Michael \enc{Hoehle}{Hoehle} & Helmut \enc{Kuechenhoff}{Kuechenhoff} (2013),
#' \emph{Determining high-risk zones for unexploded World War II bombs by using point process methodology.}
#' Journal of the Royal Statistical Society, Series C 62(2), 181-199. \cr
#'
#' @references Monia Mahling (2013),
#' \emph{Determining high-risk zones by using spatial point process methodology.}
#' Ph.D. thesis, Cuvillier Verlag \enc{Goettingen}{Goettingen},
#' available online: http://edoc.ub.uni-muenchen.de/15886/\cr
#' 
#' Heidi Seibold (2012), \emph{Determining high risk zones using point process methodology 
#' - Realization by building an R package.} Bachelor Thesis, Ludwig Maximilian University of Munich.
#' @seealso  \code{\link[spatstat]{spatstat-package}}
#' @encoding latin1
#' 
NULL