% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/higlasso.R
\name{higlasso}
\alias{higlasso}
\title{Hierarchical Integrative Group LASSO}
\usage{
higlasso(
  Y,
  X,
  Z,
  method = c("aenet", "gglasso"),
  lambda1 = NULL,
  lambda2 = NULL,
  nlambda1 = 10,
  nlambda2 = 10,
  lambda.min.ratio = 0.05,
  sigma = 1,
  degree = 2,
  maxit = 5000,
  tol = 1e-05
)
}
\arguments{
\item{Y}{A length n numeric response vector}

\item{X}{A n x p numeric matrix of covariates to basis expand}

\item{Z}{A n x m numeric matrix of non basis expanded and non
regularized covariates}

\item{method}{Type of initialization to use. Possible choices are \code{gglasso}
for group LASSO and \code{aenet} for adaptive elastic net. Default is
\code{aenet}}

\item{lambda1}{A numeric vector of main effect penalties on which to tune
By default, \code{lambda1 = NULL} and higlasso generates a length
\code{nlambda1} sequence of lambda1s based off of the data and
\code{min.lambda.ratio}}

\item{lambda2}{A numeric vector of interaction effects penalties on which to
tune. By default, \code{lambda2 = NULL} and generates a sequence (length
\code{nlambda2}) of lambda2s based off of the data and
\code{min.lambda.ratio}}

\item{nlambda1}{The number of lambda1 values to generate. Default is 10,
minimum is 2. If \code{lambda1 != NULL}, this parameter is ignored}

\item{nlambda2}{The number of lambda2 values to generate. Default is 10,
minimum is 2. If \code{lambda2 != NULL}, this parameter is ignored}

\item{lambda.min.ratio}{Ratio that calculates min lambda from max lambda.
Ignored if 'lambda1' or 'lambda2' is non NULL. Default is 0.05}

\item{sigma}{Scale parameter for integrative weights. Technically a third
tuning parameter but defaults to 1 for computational tractability}

\item{degree}{Degree of \code{bs} basis expansion. Default is 2}

\item{maxit}{Maximum number of iterations. Default is 5000}

\item{tol}{Tolerance for convergence. Default is 1e-5}
}
\value{
An object of type "higlasso" with 4 elements:
\describe{
\item{lambda}{An \code{nlambda1 x nlambda2 x 2} array containing each
pair \code{(lambda1, lambda2)} pair.}
\item{selected}{An \code{nlambda1 x nlambda2 x ncol(X)} array containing
higlasso's selections for each lambda pair.}
\item{df}{The number of nonzero selections for each lambda pair.}
\item{call}{The call that generated the output.}
}
}
\description{
HiGLASSO is a regularization based selection method designed to detect
non-linear interactions between variables, particularly exposures in
environmental health studies.
}
\details{
There are a few things to keep in mind when using \code{higlasso}
\itemize{
\item{\code{higlasso} uses the strong heredity principle. That is,
\code{X_1} and \code{X_2} must included as main effects before the
interaction \code{X_1 X_2} can be included.
}
\item{While \code{higlasso} uses integrative weights to help with
estimation, \code{higlasso} is more of a selection method.
As a result, \code{higlasso} does not output coefficient estimates,
only which variables are selected.
}
\item{Simulation studies suggest that \code{higlasso} is a very
conservative method when it comes to selecting interactions.
That is, \code{higlasso} has a low false positive rate and the
identification of a nonlinear interaction is a good indicator that
further investigation is worthwhile.
}
\item{\code{higlasso} can be slow, so it may may be beneficial to
tweak some of its settings (for example, \code{nlambda1} and
\code{nlambda2}) to get a handle on how long the method will take
before running the full model.
}}
}
\examples{
library(higlasso)

X <- as.matrix(higlasso.df[, paste0("V", 1:7)])
Y <- higlasso.df$Y
Z <- matrix(1, nrow(X))

\donttest{
# This can take a bit of time
higlasso.fit <- higlasso(Y, X, Z)
}
}
\references{
A Hierarchical Integrative Group LASSO (HiGLASSO) Framework for Analyzing
Environmental Mixtures. Jonathan Boss, Alexander Rix, Yin-Hsiu Chen, Naveen N.
Narisetty, Zhenke Wu, Kelly K. Ferguson, Thomas F. McElrath, John D. Meeker,
Bhramar Mukherjee. 2020.
arXiv:2003.12844
}
\author{
Alexander Rix
}
