% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do.hilbert.R
\name{do.hilbert}
\alias{do.hilbert}
\title{Generate the Hilbert Index from a Cut Reference Matrix}
\usage{
do.hilbert(mat, horder)
}
\arguments{
\item{mat}{the cut reference matrix}

\item{horder}{the Hilbert order, \emph{i.e.} the number of bins in each dimension}
}
\value{
a vector of indices, one for each line in \code{mat}
}
\description{
Generate the Hilbert Index corresponding to the sub-spaces defined by the coordinates
generated \emph{via} \code{\link{do.cut}}
}
\details{
For each line in \code{mat}, the function will compute the corresponding
\href{https://en.wikipedia.org/wiki/Hilbert_curve}{Hilbert index}. Each index corresponds to a specific
sub-cube of the original high-dimensional space, and consecutive hilbert index correspond to adjacent sub-cubes
}
\examples{
# generate a random 3D matrix
mat <- matrix(rnorm(300),ncol=3)
dimnames(mat)[[2]] <- LETTERS[1:3]
# generate 2 bins with a minimum bin size of 5
cuts <- make.cut(mat,n=3,count.lim=5)
show.cut(cuts)
# Generate the cuts
cut.mat <- do.cut(mat,cuts,type='fixed')
head(cut.mat)
# generate the Hilber index
hc <- do.hilbert(cut.mat,2)
plot(table(hc),type='l')
}
\author{
Marilisa Neri

Yann Abraham

John Skilling (for the original \code{C} function)
}
