% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hill_phylo_parti.R
\name{hill_phylo_parti}
\alias{hill_phylo_parti}
\title{Phylogenetic diversity of multiple sites}
\usage{
hill_phylo_parti(
  comm,
  tree,
  q = 0,
  base = exp(1),
  rel_then_pool = TRUE,
  show_warning = TRUE,
  check_data = TRUE
)
}
\arguments{
\item{comm}{A data frame of vegetation data. Sites as rows, species as columns.}

\item{tree}{A phylogeny with class 'phylo'.}

\item{q}{Hill number, \code{q} = 0 (default) to get species richness,
\code{q} = 1 to get shannon entropy, \code{q} = 2 will give inverse Simpson.}

\item{base}{default is \code{exp(1)}, the base of log.}

\item{rel_then_pool}{default is \code{TRUE.} Abundance of species are first changed to relative abundance within sites,
then pooled into one assemblage. If \code{FALSE}, sites are pooled first, then change abundance of species
to relative abundance.}

\item{show_warning}{whether to print warning, default is \code{TRUE}.}

\item{check_data}{Whether to check the community data and phylogeny. Default is `TRUE`.
Can be set to `FALSE` to speed up `hill_phylo_parti_pairwise()`.}
}
\value{
A data frame with one row (across all sites) and six columns: q, gamma diversity, alpha diversity,
beta diversity, local similarity (similar to Sorensen), and region similarity (similar to Jaccard).
}
\description{
Calculate overall phylogenetic diversity and site similarity across multiple sites.
}
\examples{
comm = dummy = FD::dummy$abun
tree = ape::rtree(n = ncol(comm), tip.label = paste0('sp', 1:8))
hill_phylo_parti(comm, tree, q = 0)
hill_phylo_parti(comm, tree, q = 0.999)
hill_phylo_parti(comm, tree, q = 1)
hill_phylo_parti(comm, tree, q = 2)

}
\references{
Chao, Anne, Chun-Huo Chiu, and Lou Jost. Unifying Species Diversity, Phylogenetic Diversity, Functional Diversity, and Related Similarity and Differentiation Measures Through Hill Numbers. Annual Review of Ecology, Evolution, and Systematics 45, no. 1 (2014): 297–324. <doi:10.1146/annurev-ecolsys-120213-091540>.
}
\author{
Chiu & Chao, Daijiang Li
}
