% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hint_main.R
\name{hint.test}
\alias{hint.test}
\title{hint.test}
\usage{
hint.test(cats, draw1, draw2, alternative = "greater")
}
\arguments{
\item{cats}{A data frame or matrix with 3 columns; the first gives the category identifier, and the second and third give the number of balls belonging to this category in the first and second urns respectively.}

\item{draw1}{A vector of objects corresponding to the categories given in cats drawn from the first urn.}

\item{draw2}{A vector of objects corresponding to the categories given in cats drawn from the second urn.}

\item{alternative}{A characer string specifying the hypothesis to be tested. Can be one of "greater", "less", or "two.sided".}
}
\value{
An object of class \code{hint.test}, which is a list containing the following components:
\itemize{
\item \code{parameters} An integer vector giving the parameter values.
\item \code{p.value} A numerical value giving the p-value associated with the test.
\item \code{alternative} A character string naming the hypothesis that was tested.
}
}
\description{
Apply the hypergeometric intersection test to categorical data to test for enrichment or depletion of intersections between two samples.
}
\details{
The hypergeometric intersection distributions describe the distribution of intersection sizes when sampling without replacement from two separate urns in which reside balls belonging to the same n object categories (see \code{\link{Hyperintersection}}).
}
\references{
Kalinka, A. T. (2013). The probability of drawing intersections: extending the hypergeometric distribution. \href{https://arxiv.org/abs/1305.0717}{arXiv.1305.0717}
}
