% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{get_person_social}
\alias{get_person_social}
\title{Get person social media accounts}
\usage{
get_person_social(types, token = Sys.getenv("HLIDAC_TOKEN"))
}
\arguments{
\item{types}{Types of social media accounts, only the following types are allowed:
'Twitter', 'Facebook_page', 'Facebook_profile', 'Instagram', 'WWW', 'Youtube'}

\item{token}{Access token}
}
\value{
data.frame with data on persons' social accounts with the
following columns:
- titulPred: academic titles written before person's name
- jmeno: given name
- prijmeni: surname
- titulPo: academic titles written after person's name
- nameId: person's ID
- profile: URL of profile at hlidacstatu.cz
- socialniSite: data.frame with data on social accounts (Type of social media,
Id of the social media account, URL)
}
\description{
Get person social media accounts
}
\examples{
\dontrun{
get_person_social(types = c("Twitter", "Instagram"))
}
}
\seealso{
\url{https://www.hlidacstatu.cz/swagger/index.html}

\url{https://www.hlidacstatu.cz/api/v1/doc}

Other Persons: 
\code{\link{get_person}()},
\code{\link{search_person_by_parameters}()},
\code{\link{search_person}()}
}
\concept{Persons}
