% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hollr.R
\name{hollr}
\alias{hollr}
\title{LLM Completions}
\usage{
hollr(
  id,
  user_message = "",
  annotators = 1,
  model,
  temperature = 1,
  top_p = 1,
  max_tokens = NULL,
  max_length = 1024,
  max_new_tokens = NULL,
  system_message = "",
  force_json = TRUE,
  flatten_json = TRUE,
  max_attempts = 10,
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  openai_organization = NULL,
  cores = 1,
  batch_size = 1,
  extract_json = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{id}{A unique identifier for the request.}

\item{user_message}{The message provided by the user.}

\item{annotators}{The number of annotators (default is 1).}

\item{model}{The name of the model to use.}

\item{temperature}{The temperature for the model's output (default is 1).}

\item{top_p}{The top-p sampling value (default is 1).}

\item{max_tokens}{The maximum number of tokens to generate (default is NULL).}

\item{max_length}{The maximum length of the input prompt (default is 1024, for local models only).}

\item{max_new_tokens}{The maximum number of new tokens to generate (default is NULL, for local models only).}

\item{system_message}{The message provided by the system (default is '').}

\item{force_json}{A logical indicating whether the output should be JSON (default is TRUE).}

\item{flatten_json}{A logical indicating whether the output should be converted to DF (default is TRUE).}

\item{max_attempts}{The maximum number of attempts to make for generating valid output (default is 10).}

\item{openai_api_key}{The API key for the OpenAI API (default is retrieved from environment variables).}

\item{openai_organization}{The organization ID for the OpenAI API (default is NULL).}

\item{cores}{The number of cores to use for parallel processing (default is 1).}

\item{batch_size}{The number of batch_size to process (default is 1, only for local models).}

\item{extract_json}{A logical indicating whether to extract and clean JSON strings from the response (default is TRUE).}

\item{verbose}{A logical indicating whether to show progress and other messages (default is TRUE).}
}
\value{
A data.table containing the generated text and metadata.
}
\description{
This function generates text using the OpenAI API or a local model.
}
\examples{
# Example using the OpenAI API
if (nzchar(Sys.getenv("OPENAI_API_KEY"))) {
  result <- hollr(id = "example_id", 
                  user_message = "What is the capital of France?", 
                  model = "gpt-3.5-turbo", 
                  openai_api_key = Sys.getenv("OPENAI_API_KEY"))
  print(result)
} else {
  message("OpenAI API key is not available. Example not run.")
}
}
