% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdai.R
\name{bdai}
\alias{bdai}
\title{Bahandary-Dai Test for Homogeniety}
\usage{
bdai(x1, x2, alfa = 0.05, table = TRUE, graph = "none")
}
\arguments{
\item{x1}{a numeric matrix containing the values of groups.}

\item{x2}{numeric matrix containing the values of group numbers.}

\item{alfa}{significance level of the test. Default number is 0.05.}

\item{table}{a logical variable that indicates table will appear or not. Default is TRUE.}

\item{graph}{box plot of groups of raw or centered data.}
}
\value{
if table is TRUE, then it gives a detailed table,
else it gives a vector of r value(r=1 when null hypothesis was rejected and r=0 when null hypothesis was accepted)
p-value and test statistic value.
}
\description{
Tests the homogeniety of variances for more than two normal groups
using Bahandary-Dai test.
}
\examples{

   data(FH_data)
   x1=FH_data$SurvivalTime
   x2=FH_data$HospitalNo
   bdai(x1,x2)
   readline(prompt = "Pause. Press <Enter> to continue...")
   bdai(x1,x2,alfa=0.10)
   readline(prompt = "Pause. Press <Enter> to continue...")
    bdai(x1,x2,alfa=0.10,table=FALSE)
    readline(prompt = "Pause. Press <Enter> to continue...")
    bdai(x1,x2,alfa=0.10,table=FALSE,graph="raw")
    readline(prompt = "Pause. Press <Enter> to continue...")
    bdai(x1,x2,alfa=0.10,table=FALSE,graph="none")
# ---THIS VERSION IS ESPECIALLY USEFUL FOR COMPARISON STUDIES BY SIMULATION---
#    #first value of the vector is r value(r=1 when rejected and r=0 when accepted null hypothesis)
# second value of the vector is the p-value and third value is the tests statistic value

}
\references{
Bhandary, M., & Dai, H. (2008). An alternative test for the equality of variances for several populations when the underlying distributions are normal. Communications in Statistics-Simulation and Computation, 38(1), 109-117.
}
\seealso{
\code{\link[homnormal]{Brown_Forsythe}}, \code{\link[homnormal]{Cat_GG}}, \code{\link[homnormal]{Cat_LR}}, \code{\link[homnormal]{genp}}, \code{\link[homnormal]{slrt}}, \code{\link[homnormal]{levene}}
}
