% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kp_historical_tables.R
\name{kp_confhistory}
\alias{kp_confhistory}
\title{\strong{Get KenPom's historical conference ratings}}
\usage{
kp_confhistory(conf)
}
\arguments{
\item{conf}{Used to limit to players in a specific conference.

Allowed values are:
'A10', 'ACC', 'AE', 'AMER',
'ASUN', 'B10', 'B12', 'BE', 'BSKY', 'BSTH',
'BW', 'CAA', 'CUSA', 'HORZ', 'IND', IVY',
'MAAC', 'MAC', 'MEAC', 'MVC', 'MWC',
'NEC', 'OVC', 'P12', 'PAT', 'SB', 'SC', 'SEC', 'SLND',
'SUM', 'SWAC', 'WAC', 'WCC'.

If you try to use a conference that doesn't exist for a given season, like 'IND' and '2018',
you'll get an empty table, as kenpom.com doesn't serve 404 pages for invalid table queries like that.
No filter applied by default.}
}
\value{
A data frame with the following columns:\tabular{ll}{
   col_name \tab types \cr
   year \tab integer \cr
   rank \tab character \cr
   tempo \tab numeric \cr
   efficiency \tab numeric \cr
   e_fg_pct \tab numeric \cr
   to_pct \tab numeric \cr
   or_pct \tab numeric \cr
   ft_rate \tab numeric \cr
   fg_2_pct \tab numeric \cr
   fg_3_pct \tab numeric \cr
   ft_pct \tab numeric \cr
   fg_3a_pct \tab numeric \cr
   a_pct \tab numeric \cr
   blk_pct \tab numeric \cr
   stl_pct \tab numeric \cr
   home_record \tab character \cr
   bids \tab character \cr
   s16 \tab character \cr
   f4 \tab character \cr
   ch \tab character \cr
   reg_season_champ \tab character \cr
   tourney_champ \tab character \cr
   best_team \tab character \cr
}
}
\description{
\strong{Get KenPom's historical conference ratings}
}
\examples{
\donttest{
  try(kp_confhistory(conf = 'ACC'))
}
}
\seealso{
Other KenPom Historical Functions: 
\code{\link{kp_coach_history}()},
\code{\link{kp_confstats}()},
\code{\link{kp_conf}()},
\code{\link{kp_pomeroy_archive_ratings}()},
\code{\link{kp_program_ratings}()},
\code{\link{kp_team_history}()}
}
\concept{KenPom Historical Functions}
\keyword{Conference}
\keyword{History}
