% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_boxscore.R
\name{nba_boxscoreplayertrackv2}
\alias{nba_boxscoreplayertrackv2}
\title{\strong{Get NBA Stats API Boxscore Player Tracking V2}}
\usage{
nba_boxscoreplayertrackv2(game_id, ...)
}
\arguments{
\item{game_id}{Game ID}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: PlayerStats, TeamStats

\strong{PlayerStats}\tabular{ll}{
   col_name \tab types \cr
   GAME_ID \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_CITY \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   START_POSITION \tab character \cr
   COMMENT \tab character \cr
   MIN \tab character \cr
   SPD \tab character \cr
   DIST \tab character \cr
   ORBC \tab character \cr
   DRBC \tab character \cr
   RBC \tab character \cr
   TCHS \tab character \cr
   SAST \tab character \cr
   FTAST \tab character \cr
   PASS \tab character \cr
   AST \tab character \cr
   CFGM \tab character \cr
   CFGA \tab character \cr
   CFG_PCT \tab character \cr
   UFGM \tab character \cr
   UFGA \tab character \cr
   UFG_PCT \tab character \cr
   FG_PCT \tab character \cr
   DFGM \tab character \cr
   DFGA \tab character \cr
   DFG_PCT \tab character \cr
}


\strong{TeamStats}\tabular{ll}{
   col_name \tab types \cr
   GAME_ID \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_CITY \tab character \cr
   MIN \tab character \cr
   DIST \tab character \cr
   ORBC \tab character \cr
   DRBC \tab character \cr
   RBC \tab character \cr
   TCHS \tab character \cr
   SAST \tab character \cr
   FTAST \tab character \cr
   PASS \tab character \cr
   AST \tab character \cr
   CFGM \tab character \cr
   CFGA \tab character \cr
   CFG_PCT \tab character \cr
   UFGM \tab character \cr
   UFGA \tab character \cr
   UFG_PCT \tab character \cr
   FG_PCT \tab character \cr
   DFGM \tab character \cr
   DFGA \tab character \cr
   DFG_PCT \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Boxscore Player Tracking V2}

\strong{Get NBA Stats API Boxscore Player Tracking V2}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_boxscoreplayertrackv2(game_id = "0022200021")
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Boxscore Functions: 
\code{\link{nba_boxscoreadvancedv2}()},
\code{\link{nba_boxscoredefensive}()},
\code{\link{nba_boxscorefourfactorsv2}()},
\code{\link{nba_boxscorematchups}()},
\code{\link{nba_boxscoremiscv2}()},
\code{\link{nba_boxscorescoringv2}()},
\code{\link{nba_boxscoresummaryv2}()},
\code{\link{nba_boxscoretraditionalv2}()},
\code{\link{nba_boxscoreusagev2}()},
\code{\link{nba_gamerotation}()},
\code{\link{nba_hustlestatsboxscore}()},
\code{\link{nba_live_boxscore}()}

Other NBA Player Tracking Functions: 
\code{\link{nba_leaguedashoppptshot}()},
\code{\link{nba_leaguedashplayerptshot}()},
\code{\link{nba_leaguedashptdefend}()},
\code{\link{nba_leaguedashptstats}()},
\code{\link{nba_leaguedashptteamdefend}()},
\code{\link{nba_leaguedashteamptshot}()},
\code{\link{nba_playerdashptpass}()},
\code{\link{nba_playerdashptreb}()},
\code{\link{nba_playerdashptshotdefend}()},
\code{\link{nba_playerdashptshots}()},
\code{\link{nba_synergyplaytypes}()},
\code{\link{nba_teamdashptpass}()},
\code{\link{nba_teamdashptreb}()},
\code{\link{nba_teamdashptshots}()}
}
\author{
Saiem Gilani
}
\concept{NBA Boxscore Functions}
\concept{NBA Player Tracking Functions}
