% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_league_dash.R
\name{nba_leaguedashptstats}
\alias{nba_leaguedashptstats}
\title{\strong{Get NBA Stats API League Dashboard Player Tracking - Stats}}
\usage{
nba_leaguedashptstats(
  college = "",
  conference = "",
  country = "",
  date_from = "",
  date_to = "",
  division = "",
  draft_pick = "",
  draft_year = "",
  game_scope = "",
  height = "",
  last_n_games = 0,
  league_id = "00",
  location = "",
  month = 0,
  opponent_team_id = 0,
  outcome = "",
  po_round = "",
  per_mode = "PerGame",
  period = "",
  player_experience = "",
  player_or_team = "Player",
  player_position = "",
  pt_measure_type = "Drives",
  season = year_to_season(most_recent_nba_season() - 1),
  season_segment = "",
  season_type = "Regular Season",
  starter_bench = "",
  team_id = "",
  vs_conference = "",
  vs_division = "",
  weight = "",
  ...
)
}
\arguments{
\item{college}{college}

\item{conference}{conference}

\item{country}{country}

\item{date_from}{date_from}

\item{date_to}{date_to}

\item{division}{division}

\item{draft_pick}{draft_pick}

\item{draft_year}{draft_year}

\item{game_scope}{game_scope}

\item{height}{height}

\item{last_n_games}{last_n_games}

\item{league_id}{league_id}

\item{location}{location}

\item{month}{month}

\item{opponent_team_id}{opponent_team_id}

\item{outcome}{outcome}

\item{po_round}{po_round}

\item{per_mode}{per_mode}

\item{period}{period}

\item{player_experience}{player_experience}

\item{player_or_team}{player_or_team}

\item{player_position}{player_position}

\item{pt_measure_type}{pt_measure_type}

\item{season}{season}

\item{season_segment}{season_segment}

\item{season_type}{season_type}

\item{starter_bench}{starter_bench}

\item{team_id}{team_id}

\item{vs_conference}{vs_conference}

\item{vs_division}{vs_division}

\item{weight}{weight}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: LeagueDashPtStats

\strong{LeagueDashPtStats}\tabular{ll}{
   col_name \tab types \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   GP \tab character \cr
   W \tab character \cr
   L \tab character \cr
   MIN \tab character \cr
   DRIVES \tab character \cr
   DRIVE_FGM \tab character \cr
   DRIVE_FGA \tab character \cr
   DRIVE_FG_PCT \tab character \cr
   DRIVE_FTM \tab character \cr
   DRIVE_FTA \tab character \cr
   DRIVE_FT_PCT \tab character \cr
   DRIVE_PTS \tab character \cr
   DRIVE_PTS_PCT \tab character \cr
   DRIVE_PASSES \tab character \cr
   DRIVE_PASSES_PCT \tab character \cr
   DRIVE_AST \tab character \cr
   DRIVE_AST_PCT \tab character \cr
   DRIVE_TOV \tab character \cr
   DRIVE_TOV_PCT \tab character \cr
   DRIVE_PF \tab character \cr
   DRIVE_PF_PCT \tab character \cr
}
}
\description{
\strong{Get NBA Stats API League Dashboard Player Tracking - Stats}

\strong{Get NBA Stats API League Dashboard Player Tracking - Stats}
}
\details{
\href{https://www.nba.com/stats/players/drives}{Players Tracking (Second Spectrum) Stats}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_leaguedashptstats(league_id = '00', season = year_to_season(most_recent_nba_season() - 1))
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA League Functions: 
\code{\link{nba_leaguedashlineups}()},
\code{\link{nba_leaguedashoppptshot}()},
\code{\link{nba_leaguedashplayerbiostats}()},
\code{\link{nba_leaguedashplayerclutch}()},
\code{\link{nba_leaguedashplayerptshot}()},
\code{\link{nba_leaguedashplayershotlocations}()},
\code{\link{nba_leaguedashplayerstats}()},
\code{\link{nba_leaguedashptdefend}()},
\code{\link{nba_leaguedashptteamdefend}()},
\code{\link{nba_leaguedashteamclutch}()},
\code{\link{nba_leaguedashteamptshot}()},
\code{\link{nba_leaguedashteamshotlocations}()},
\code{\link{nba_leaguedashteamstats}()},
\code{\link{nba_leaguegamefinder}()},
\code{\link{nba_leaguegamelog}()},
\code{\link{nba_leaguelineupviz}()},
\code{\link{nba_leagueplayerondetails}()},
\code{\link{nba_leagueseasonmatchups}()},
\code{\link{nba_leaguestandingsv3}()},
\code{\link{nba_leaguestandings}()},
\code{\link{nba_matchupsrollup}()},
\code{\link{nba_playoffpicture}()},
\code{\link{nba_shotchartleaguewide}()}

Other NBA Player Tracking Functions: 
\code{\link{nba_boxscoreplayertrackv2}()},
\code{\link{nba_leaguedashoppptshot}()},
\code{\link{nba_leaguedashplayerptshot}()},
\code{\link{nba_leaguedashptdefend}()},
\code{\link{nba_leaguedashptteamdefend}()},
\code{\link{nba_leaguedashteamptshot}()},
\code{\link{nba_playerdashptpass}()},
\code{\link{nba_playerdashptreb}()},
\code{\link{nba_playerdashptshotdefend}()},
\code{\link{nba_playerdashptshots}()},
\code{\link{nba_synergyplaytypes}()},
\code{\link{nba_teamdashptpass}()},
\code{\link{nba_teamdashptreb}()},
\code{\link{nba_teamdashptshots}()}
}
\author{
Saiem Gilani
}
\concept{NBA League Functions}
\concept{NBA Player Tracking Functions}
