% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_scoreboard.R
\name{nba_scoreboardv3}
\alias{nba_scoreboardv3}
\title{\strong{Get NBA Stats API Scoreboard V3}}
\usage{
nba_scoreboardv3(league_id = "00", game_date = "2023-03-26", ...)
}
\arguments{
\item{league_id}{League - default: '00'. Other options include '10': WNBA, '20': G-League}

\item{game_date}{Game Date}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a tibble with the following scoreboard data:\tabular{ll}{
   col_name \tab types \cr
   game_id \tab character \cr
   game_code \tab character \cr
   game_status \tab integer \cr
   game_status_text \tab character \cr
   game_date \tab character \cr
   game_time_utc \tab character \cr
   game_et \tab character \cr
   home_team_id \tab integer \cr
   home_team_name \tab character \cr
   home_team_city \tab character \cr
   home_team_tricode \tab character \cr
   home_team_slug \tab character \cr
   away_team_id \tab integer \cr
   away_team_name \tab character \cr
   away_team_city \tab character \cr
   away_team_tricode \tab character \cr
   away_team_slug \tab character \cr
   period \tab integer \cr
   game_clock \tab character \cr
   regulation_periods \tab integer \cr
   series_game_number \tab character \cr
   series_text \tab character \cr
   if_necessary \tab logical \cr
   series_conference \tab character \cr
   po_round_desc \tab character \cr
   game_subtype \tab character \cr
   game_home_leaders_person_id \tab integer \cr
   game_home_leaders_name \tab character \cr
   game_home_leaders_player_slug \tab character \cr
   game_home_leaders_jersey_num \tab character \cr
   game_home_leaders_position \tab character \cr
   game_home_leaders_team_tricode \tab character \cr
   game_home_leaders_points \tab integer \cr
   game_home_leaders_rebounds \tab integer \cr
   game_home_leaders_assists \tab integer \cr
   game_away_leaders_person_id \tab integer \cr
   game_away_leaders_name \tab character \cr
   game_away_leaders_player_slug \tab character \cr
   game_away_leaders_jersey_num \tab character \cr
   game_away_leaders_position \tab character \cr
   game_away_leaders_team_tricode \tab character \cr
   game_away_leaders_points \tab integer \cr
   game_away_leaders_rebounds \tab integer \cr
   game_away_leaders_assists \tab integer \cr
   team_home_leaders_person_id \tab integer \cr
   team_home_leaders_name \tab character \cr
   team_home_leaders_player_slug \tab character \cr
   team_home_leaders_jersey_num \tab character \cr
   team_home_leaders_position \tab character \cr
   team_home_leaders_team_tricode \tab character \cr
   team_home_leaders_points \tab numeric \cr
   team_home_leaders_rebounds \tab numeric \cr
   team_home_leaders_assists \tab numeric \cr
   team_away_leaders_person_id \tab integer \cr
   team_away_leaders_name \tab character \cr
   team_away_leaders_player_slug \tab character \cr
   team_away_leaders_jersey_num \tab character \cr
   team_away_leaders_position \tab character \cr
   team_away_leaders_team_tricode \tab character \cr
   team_away_leaders_points \tab numeric \cr
   team_away_leaders_rebounds \tab numeric \cr
   team_away_leaders_assists \tab numeric \cr
   team_season_leaders_flag \tab integer \cr
   home_wins \tab integer \cr
   home_losses \tab integer \cr
   home_score \tab integer \cr
   home_seed \tab integer \cr
   home_in_bonus \tab logical \cr
   home_timeouts_remaining \tab integer \cr
   home_periods \tab list \cr
   away_wins \tab integer \cr
   away_losses \tab integer \cr
   away_score \tab integer \cr
   away_seed \tab integer \cr
   away_in_bonus \tab logical \cr
   away_timeouts_remaining \tab integer \cr
   away_periods \tab list \cr
   league_id \tab character \cr
   league \tab character \cr
   broadcasters \tab data.frame \cr
}
}
\description{
\strong{Get NBA Stats API Scoreboard V3}

\strong{Get NBA Stats API Scoreboard V3}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_scoreboardv3(league_id = '00', game_date = '2023-03-26')
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Schedule Functions: 
\code{\link{nba_schedule}()},
\code{\link{nba_scoreboardv2}()},
\code{\link{nba_scoreboard}()},
\code{\link{nba_todays_scoreboard}()}
}
\author{
Saiem Gilani
}
\concept{NBA Schedule Functions}
