% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbagl_pbp.R
\name{nbagl_pbp}
\alias{nbagl_pbp}
\title{\strong{Get NBA Data API Play-by-Play for G-League Games}}
\usage{
nbagl_pbp(game_id, ...)
}
\arguments{
\item{game_id}{Game ID - 10 digits, i.e. 0021900001}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a data frame of play by play with the following columns:\tabular{ll}{
   col_name \tab types \cr
   period \tab integer \cr
   evt \tab integer \cr
   wallclk \tab character \cr
   cl \tab character \cr
   de \tab character \cr
   locX \tab integer \cr
   locY \tab integer \cr
   opt1 \tab integer \cr
   opt2 \tab integer \cr
   opt3 \tab integer \cr
   opt4 \tab integer \cr
   mtype \tab integer \cr
   etype \tab integer \cr
   opid \tab character \cr
   tid \tab integer \cr
   pid \tab integer \cr
   hs \tab integer \cr
   vs \tab integer \cr
   epid \tab character \cr
   oftid \tab integer \cr
   ord \tab integer \cr
   pts \tab integer \cr
}
}
\description{
Scrapes the NBA Data API for Play By Play for G League games
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nbagl_pbp(game_id = "2012200001")
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA G-League Functions: 
\code{\link{nbagl_players}()},
\code{\link{nbagl_schedule}()},
\code{\link{nbagl_standings}()}
}
\author{
Billy Fryer
}
\concept{NBA G-League Functions}
