test_that("NBA Boxscore Matchups V3", {
  skip_on_cran()
  skip_on_ci()

  x <- nba_boxscorematchupsv3(game_id = "0022200021")

  cols_x1 <- c(
    "game_id",
    "away_team_id",
    "home_team_id",
    "team_id",
    "team_name",
    "team_city",
    "team_tricode",
    "team_slug",
    "person_id",
    "first_name",
    "family_name",
    "name_i",
    "player_slug",
    "position",
    "comment",
    "jersey_num",
    "matchups_person_id",
    "matchups_first_name",
    "matchups_family_name",
    "matchups_name_i",
    "matchups_player_slug",
    "matchups_jersey_num",
    "matchup_minutes",
    "matchup_minutes_sort",
    "partial_possessions",
    "percentage_defender_total_time",
    "percentage_offensive_total_time",
    "percentage_total_time_both_on",
    "switches_on",
    "player_points",
    "team_points",
    "matchup_assists",
    "matchup_potential_assists",
    "matchup_turnovers",
    "matchup_blocks",
    "matchup_field_goals_made",
    "matchup_field_goals_attempted",
    "matchup_field_goals_percentage",
    "matchup_three_pointers_made",
    "matchup_three_pointers_attempted",
    "matchup_three_pointers_percentage",
    "help_blocks",
    "help_field_goals_made",
    "help_field_goals_attempted",
    "help_field_goals_percentage",
    "matchup_free_throws_made",
    "matchup_free_throws_attempted",
    "shooting_fouls"
  )

  cols_x2 <- c(
    "game_id",
    "away_team_id",
    "home_team_id",
    "team_id",
    "team_name",
    "team_city",
    "team_tricode",
    "team_slug",
    "person_id",
    "first_name",
    "family_name",
    "name_i",
    "player_slug",
    "position",
    "comment",
    "jersey_num",
    "matchups_person_id",
    "matchups_first_name",
    "matchups_family_name",
    "matchups_name_i",
    "matchups_player_slug",
    "matchups_jersey_num",
    "matchup_minutes",
    "matchup_minutes_sort",
    "partial_possessions",
    "percentage_defender_total_time",
    "percentage_offensive_total_time",
    "percentage_total_time_both_on",
    "switches_on",
    "player_points",
    "team_points",
    "matchup_assists",
    "matchup_potential_assists",
    "matchup_turnovers",
    "matchup_blocks",
    "matchup_field_goals_made",
    "matchup_field_goals_attempted",
    "matchup_field_goals_percentage",
    "matchup_three_pointers_made",
    "matchup_three_pointers_attempted",
    "matchup_three_pointers_percentage",
    "help_blocks",
    "help_field_goals_made",
    "help_field_goals_attempted",
    "help_field_goals_percentage",
    "matchup_free_throws_made",
    "matchup_free_throws_attempted",
    "shooting_fouls"
  )

  expect_equal(sort(colnames(x[[1]])), sort(cols_x1))
  expect_s3_class(x[[1]], "data.frame")
  expect_equal(sort(colnames(x[[2]])), sort(cols_x2))
  expect_s3_class(x[[2]], "data.frame")

  Sys.sleep(3)

})
