% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfIndex.R
\name{rfIndex}
\alias{rfIndex}
\title{Create a full index object by random forest approach}
\usage{
rfIndex(trans_df, dep_var = NULL, ind_var = NULL, rf_spec = NULL,
  ...)
}
\arguments{
\item{trans_df}{data.frame of transactions}

\item{dep_var}{default = NULL; Dependent variable in hedonic model}

\item{ind_var}{default = NULL; Independent variables in the hedonic model}

\item{rf_spec}{default = NULL; Full random forest model specification}

\item{...}{Additional Arguments}
}
\value{
`hpi`` object.  S3 list with:
\describe{
\item{data}{`hpidata` object}
\item{model}{`hpimodel` object}
\item{index}{`hpiindex` object}
}
}
\description{
Wrapper to create index object via entire random forest approach
}
\section{Further Details}{

Additional argument need to provide necessary argument for create `hpidata` objects if
the `trans_df` object is not of that class.
}

\examples{


 # Load data
 data(ex_sales)

 # Create index with raw transaction data
 rf_index <- rfIndex(trans_df = ex_sales,
                     periodicity = 'monthly',
                     min_date = '2010-06-01',
                     max_date = '2015-11-30',
                     adj_type = 'clip',
                     date = 'sale_date',
                     price = 'sale_price',
                     trans_id = 'sale_id',
                     prop_id = 'pinx',
                     estimator = 'pdp',
                     log_dep = TRUE,
                     trim_model = TRUE,
                     max_period = 48,
                     dep_var = 'price',
                     ind_var = c('tot_sf', 'beds', 'baths'),
                     smooth = FALSE,
                     ntrees = 10,
                     sim_count = 2)

}
