% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateHalfsib.R
\name{.simulateHalfsib}
\alias{.simulateHalfsib}
\title{Simulate Half-Sibling Genotypes}
\usage{
.simulateHalfsib(
  numInd = 40,
  numSNP = 10000,
  recbound = 0:6,
  type = "genotype"
)
}
\arguments{
\item{numInd}{Integer, the number of half-siblings to simulate.}

\item{numSNP}{Integer, the number of SNPs to simulate for each individual.}

\item{recbound}{Numeric vector, specifying the range of possible recombination events to simulate.}

\item{type}{Character string, specifying the type of data to return: "genotype" for genotypic data or any other string for phased genotypic data.}
}
\value{
Depending on the \code{type} parameter, this function returns a matrix of simulated genotypic data
for half-siblings. If \code{type} is "genotype", it returns unphased genotypic data; otherwise, it returns phased genotypic data.
}
\description{
This function simulates genotypes for a set of half-siblings based on specified parameters,
including the number of individuals, the number of SNPs, recombination boundaries, and the type of data to return.
It generates a sire genotype, maternal half-sib genotypes, and combines these to simulate offspring genotypes,
optionally returning phased genotypes based on recombination events.
}
\examples{
sim_genotypes <- .simulateHalfsib(numInd = 40, numSNP = 10000, recbound = 0:6, type = "genotype")
dim(sim_genotypes) # Should return 40 rows (individuals) and 100 columns (SNPs)

}
