% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_pool_sample.R
\name{make_sample_indices_unique}
\alias{make_sample_indices_unique}
\title{Make the output type ID values of sample forecasts distinct for different
models}
\usage{
make_sample_indices_unique(model_out_tbl)
}
\arguments{
\item{model_out_tbl}{an object of class \code{model_out_tbl} with component
model outputs (e.g., predictions).}
}
\value{
a model_out_tbl object with unique output type ID values for different
models but otherwise identical to the input model_out_tbl.
}
\description{
Make the output type ID values of sample forecasts distinct for different
models
}
\details{
The new \code{output_type_id} column values will follow one of two patterns,
depending on whether the column is detected to be numeric:
\enumerate{
\item If the output type ID is not numeric (may be a character):
A concatenation of the prediction's model ID and original output type ID
\item If the output type ID is numeric: A numeric representation of the above
pattern rendered as a factor.
}
}
