% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-schema.R
\name{get_schema}
\alias{get_schema}
\title{Download a schema}
\usage{
get_schema(schema_url)
}
\arguments{
\item{schema_url}{The download URL for a given config schema version.}
}
\value{
Contents of the JSON schema as a character string.
}
\description{
Download a schema
}
\examples{
\dontshow{if (asNamespace("hubUtils")$not_rcmd_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
schema_url <- get_schema_url(config = "tasks", version = "v0.0.0.9")
get_schema(schema_url)
\dontshow{\}) # examplesIf}
}
\seealso{
Other functions supporting config file validation: 
\code{\link{get_schema_url}()},
\code{\link{get_schema_valid_versions}()}
}
\concept{functions supporting config file validation}
