% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chas.R
\name{get_hud_chas_data}
\alias{get_hud_chas_data}
\title{Get HUD Comprehensive Housing Affordability Strategy (CHAS) data at the Place, MCD, County, State, National Level from HUD.}
\usage{
get_hud_chas_data(
  entityid,
  stateid,
  type,
  yr,
  hud_key = Sys.getenv("HUD_API_KEY")
)
}
\arguments{
\item{entityid}{Character string containing the 'fips_code' from get_hud_fmr_listcounties(...) or 'cbsa_code' from get_hud_fmr_listmetros(...).}

\item{stateid}{Character string containing the 'fips_code' for the State.}

\item{type}{Character string indicating the summary level. Option include 1-5. 1 - Nation, 2 - State, 3 - County, 4 - MCD, 5 - Place.}

\item{yr}{Character string indicating the year.}

\item{hud_key}{Character string indicating your API key from HUD.}
}
\value{
A list of data tables containing fair market rent data from HUD.
}
\description{
Provides Comprehensive Housing Affordability Strategy (CHAS) data at the Place, MCD, County, State, National Level from HUD.
}
\details{
Provides fair market rent data at the County and MSA level from HUD.
}
\examples{
\dontrun{
library(hudr)

hud_key <- Sys.getenv("HUD_API_KEY")

chas_cnty_dt <- get_hud_chas_data(entityid = "033", stateid = "53",
                                  type = "3", yr = "2014-2018",
                                  hud_key = hud_key)
}
}
\author{
Paul Richardson
}
