% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humidity.R
\name{SH2RH}
\alias{SH2RH}
\title{convert specific humidity into relative humidity}
\usage{
SH2RH(q, t, p = 101325, isK = TRUE)
}
\arguments{
\item{q}{specific humidity \eqn{q} (\eqn{kg/kg})}

\item{t}{temperature in Kelvin (K) or in degree Celsius (°C)}

\item{p}{atmospheric pressure in Pascal (Pa). The default is standard atmospheric pressure of 101325Pa.}

\item{isK}{logical indicator whether temperature is in Kelvin (K). The default value is TRUE.}
}
\value{
numeric relative humidity in %.
}
\description{
Climate models usually provide specific humidity only; however, relative humidity is used to compute \href{https://www.weather.gov/ama/heatindex}{heat index} that is really useful for health impacts studies. This function converts specific humidity \eqn{q} into relative humidity \eqn{\psi} at temperature \eqn{t} and under atmospheric pressure \eqn{q}.
}
\examples{
SH2RH(0.005867353, 22.25, p = 101325, isK = FALSE)
}
\seealso{
\code{\link{AH}}, \code{\link{SH}}.
}
\author{
Jun Cai (\email{cai-j12@mails.tsinghua.edu.cn}), PhD candidate from
Department of Earth System Science, Tsinghua University
}
