% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_probs.R
\name{update_probs}
\alias{update_probs}
\title{MCMC Probability Update Function for Hurdle Model Count Data Regression}
\usage{
update_probs(y, x, hurd, p, q, beta.prior.mean, beta.prior.sd, pZ, pT, pE, beta,
  XB2, XB3, beta.acc, beta.tune)
}
\arguments{
\item{y}{numeric response vector.}

\item{x}{optional numeric predictor matrix.}

\item{hurd}{numeric threshold for 'extreme' observations of two-hurdle 
models.}

\item{p}{numeric vector of current 'p' probability parameter values for 
zero-value observations.}

\item{q}{numeric vector of current 'q' probability parameter values for 
'extreme' observations.}

\item{beta.prior.mean}{mu parameter for normal prior distributions.}

\item{beta.prior.sd}{standard deviation for normal prior distributions.}

\item{pZ}{numeric vector of current 'zero probability' likelihood values.}

\item{pT}{numeric vector of current 'typical probability' likelihood values.}

\item{pE}{numeric vector of current 'extreme probability' likelihood values.}

\item{beta}{numeric matrix of current regression coefficient parameter values.}

\item{XB2}{\eqn{x*beta[,2]} product matrix.}

\item{XB3}{\eqn{x*beta[,3]} product matrix.}

\item{beta.acc}{numeric matrix of current MCMC acceptance rates for 
regression coefficient parameters.}

\item{beta.tune}{numeric matrix of current MCMC tuning values for regression 
coefficient estimation.}
}
\value{
A list of MCMC-updated regression coefficients for the estimation of 
the parameters 'p' (the probability of a zero-value observation) and 'q' 
(the probability of an 'extreme' observation) as well as each coefficient's 
MCMC acceptance ratio.
}
\description{
MCMC algorithm for updating the likelihood probabilities in 
hurdle model regression using \code{\link{hurdle}}.
}
\seealso{
\code{\link{hurdle}} \cr
\code{\link{dist_ll}}
}
\author{
Taylor Trippe <\email{ttrippe@luc.edu}> \cr
Earvin Balderama <\email{ebalderama@luc.edu}>
}
