% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ustat.R
\name{hweustat}
\alias{hweustat}
\title{U-process minimizer approach to equilibrium testing and double reduction
estimation}
\usage{
hweustat(nvec, thresh = NULL, effdf = TRUE)
}
\arguments{
\item{nvec}{A vector containing the observed genotype counts,
where \code{nvec[[i]]} is the number of individuals with genotype
\code{i-1}. This should be of length \code{ploidy+1}.}

\item{thresh}{The threshold for ignoring the genotype. We keep
genotypes such that \code{nvec >= thresh}.
Setting this to \code{0} uses all genotypes. Setting this to
\code{NULL} uses a heuristic that works well in practice.}

\item{effdf}{A logical. Should we use the ad-hoc
"effective degrees of freedom" (\code{TRUE}) or not (\code{FALSE})?}
}
\value{
A list with some or all of the following elements:
\describe{
\item{\code{alpha}}{The estimated double reduction parameter(s).
In diploids, this value is \code{NULL}.}
\item{\code{chisq_hwe}}{The chi-square test statistic for testing
against the null of equilibrium.}
\item{\code{df_hwe}}{The degrees of freedom associated with
\code{chisq_hwe}.}
\item{\code{p_hwe}}{The p-value against the null of equilibrium.}
}
}
\description{
Estimates double reduction and tests for equilibrium while accounting
for double reduction. It does this using an approach called
"U-process minimization", where we minimize a function of a U-statistic
that should be 0 at equilibrium given the true double reduction rate.
}
\details{
This is a two-step estimator, where we first obtain a consistent
estimate of the double reduction parameter, use this to
estimate the covariance of estimators, then use this to obtain
our final estimate of the double reduction parameter.
}
\examples{
set.seed(1)
ploidy <- 6
size <- 1000
r <- 0.1
alpha <- 0.1
qvec <- hwefreq(r = r, alpha = alpha, ploidy = ploidy)
nvec <- c(rmultinom(n = 1, size = size, prob = qvec))
hweustat(nvec = nvec)

}
\author{
David Gerard
}
