% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movAvg.R
\name{movAvg}
\alias{movAvg}
\title{Moving average windows}
\usage{
movAvg(df, k, pos)
}
\arguments{
\item{df}{data frame with the serie that you want to smooth. By default, t he function uses column 2.}

\item{k}{numeric value with windows size., e.g.: 5}

\item{pos}{string with the position of the window: \itemize{
     \item 'izq': left aligned. The output value is on the left, so the function weights the (k - 1) values at the right side.
     \item 'der': right aligned. The output value is on the right, so the function weights the (k - 1) values at the left side.
     \item 'cen': center. The output value is in the middle of the window.
}}
}
\value{
data frame with the smooth serie.
}
\description{
Smooth a numeric serie with a moving average windows
}
\examples{
# Relative path to raw data
full_path <- system.file('extdata', package = "hydroToolkit")

# Apply function
cuevas <- read_IANIGLA(file = 'Cuevas.csv', path = full_path)   
               
# Get air temperature
cuevas_tair <- cuevas[ , 1:2]

# Create a moving average serie of Tair
Tair_mov <- movAvg(df = cuevas_tair, k = 10, pos = 'izq')

}
