% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10_report_hydroMet.R
\name{report_hydroMet}
\alias{report_hydroMet}
\alias{report_hydroMet,hydroMet_BDHI-method}
\alias{report_hydroMet,hydroMet_CR2-method}
\alias{report_hydroMet,hydroMet_DGI-method}
\alias{report_hydroMet,hydroMet_IANIGLA-method}
\title{Object summaries}
\usage{
report_hydroMet(
  obj,
  slot_name,
  col_name,
  start_date = NULL,
  end_date = NULL,
  Lang = "spanish"
)

\S4method{report_hydroMet}{hydroMet_BDHI}(
  obj,
  slot_name,
  col_name,
  start_date = NULL,
  end_date = NULL,
  Lang = "spanish"
)

\S4method{report_hydroMet}{hydroMet_CR2}(
  obj,
  slot_name,
  col_name,
  start_date = NULL,
  end_date = NULL,
  Lang = "spanish"
)

\S4method{report_hydroMet}{hydroMet_DGI}(
  obj,
  slot_name,
  col_name,
  start_date = NULL,
  end_date = NULL,
  Lang = "spanish"
)

\S4method{report_hydroMet}{hydroMet_IANIGLA}(
  obj,
  slot_name,
  col_name,
  start_date = NULL,
  end_date = NULL,
  Lang = "spanish"
)
}
\arguments{
\item{obj}{an \code{hydroMet_XXX} object.}

\item{slot_name}{a single or vector string containing the slot(s) to report.}

\item{col_name}{a single or vector string with the name of the column to report in \code{slot_name}.}

\item{start_date}{optional (default is the first \code{Date}). Single string or \code{POSIXct} with the starting \code{Date} to report.}

\item{end_date}{optional (default is the last \code{Date}). Single string or \code{POSIXct} with the last \code{Date} to report.}

\item{Lang}{optional (default value is \code{spanish}). Single string with the language to report results: \code{spanish} or \code{english}.}
}
\value{
A list containing two \code{data frames}: the first one with miss data and the second with the \code{mean}, \code{sd}, \code{max} and \code{min} values of the series.
}
\description{
This method returns a list with two elements: the first one is a \code{data frame} with miss data (see also \link{report_miss_data}) and the second one is also a \code{data frame} with the \code{mean}, \code{sd}, \code{max} and \code{min} values.
}
\section{Functions}{
\itemize{
\item \code{report_hydroMet,hydroMet_BDHI-method}: report method for BDHI class

\item \code{report_hydroMet,hydroMet_CR2-method}: report method for CR2 class

\item \code{report_hydroMet,hydroMet_DGI-method}: report method for DGI class

\item \code{report_hydroMet,hydroMet_IANIGLA-method}: report method for IANIGLA class
}}

\examples{
# Create IANIGLA class
cuevas <- create_hydroMet(class_name = 'IANIGLA')
 
# List with meteorological variables (slots in BDHI's object)
cargar <- list( slotNames(x = 'hydroMet_IANIGLA')[2:11] )

# Assign as names the files
hydro_files   <- list.files( system.file('extdata', package = "hydroToolkit"), pattern = 'Cuevas' )
names(cargar) <- hydro_files

# Build met-station
cuevas <- build_hydroMet(obj = cuevas, slot_list = cargar, 
           path = system.file('extdata', package = "hydroToolkit") )

# Get report
report_hydroMet(obj = cuevas, slot_name = 'kin', col_name = 'kin_1')

}
