% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdf.R
\name{writeNcdf}
\alias{writeNcdf}
\title{Write to NetCDF file using hyfo list file}
\usage{
writeNcdf(
  gridData,
  filePath,
  missingValue = 1e+20,
  tz = "GMT",
  units = NULL,
  version = 3
)
}
\arguments{
\item{gridData}{A hyfo list file from \code{\link{loadNcdf}}}

\item{filePath}{A path of the new NetCDF file, should end with ".nc"}

\item{missingValue}{A number representing the missing value in the NetCDF file, default
is 1e20
#' @param tz A string representing the time zone, default is GMT, if you know what time zone is 
you can assign it in the argument. If \code{tz = ''}, current time zone will be taken.}

\item{tz}{time zone, default is "GMT"}

\item{units}{A string showing in which unit you are putting in the NetCDF file, it can be 
seconds or days and so on. If not specified, the function will pick up the possible largest 
time units from \code{c('weeks', 'days', 'hours', 'mins', 'secs')}}

\item{version}{ncdf file versions, default is 3, if 4 is chosen, output file will be foreced to version 4.}
}
\value{
An NetCDF version 3 file.
}
\description{
Write to NetCDF file using hyfo list file
}
\examples{
# First open the test NETcDF file.
filePath <- system.file("extdata", "tnc.nc", package = "hyfo")


# Then if you don't know the variable name, you can use \code{getNcdfVar} to get variable name
varname <- getNcdfVar(filePath)

nc <- loadNcdf(filePath, varname)

# Then write to your work directory

\dontrun{
writeNcdf(nc, 'test.nc')
}


# More examples can be found in the user manual on https://yuanchao-xu.github.io/hyfo/

}
\references{
\itemize{
\item David Pierce (2015). ncdf4: Interface to Unidata netCDF (Version 4 or
Earlier) Format Data Files. R package version 1.14.1.
https://CRAN.R-project.org/package=ncdf4

\item Santander MetGroup (2015). ecomsUDG.Raccess: R interface to the ECOMS User Data Gateway. R package
version 2.2-6. http://meteo.unican.es/ecoms-udg

}
}
