% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube.R
\docType{methods}
\name{add.aggregation}
\alias{add.aggregation}
\alias{add.aggregation,Cube-method}
\title{Adds an aggregation to a hypercube}
\usage{
add.aggregation(
  x,
  dimensions,
  fun = c("sum", "min", "max", "prod", "mean", "median", "sd", "count")
)
}
\arguments{
\item{x}{Hypercube for which the selection criteria will be defined.}

\item{dimensions}{A vector of dimensions that are used in the aggregation.}

\item{fun}{The function that is used for aggregation. Possible functions are sum, prod, min, max, mean, median, sd, and count.}
}
\value{
Returns a \code{Cube} object with the added aggregation.
}
\description{
This function adds a further aggregation to a hypercube.
The cube itself will not be changed. The aggregation only affect the data that
will be shown when printing the cube. Note that selection criteria will be applied before
aggregating the data.
}
\examples{

data("sales")
cube = generateCube(sales, columns = list(time = c("month", "year"),
      location = c("state"), product = "product"), valueColumn = "amount")
cube = add.aggregation(cube, dimensions = c("month", "year"), fun = "sum")
cube

}
\seealso{
\code{\link[=Cube-class]{Cube}} \code{\link{remove.aggregation}} \code{\link{add.selection}}
}
\author{
Michael Scholz \email{michael.scholz@th-deg.de}
}
\keyword{methods}
