% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypergate.R
\name{reoptimize_strategy}
\alias{reoptimize_strategy}
\title{reoptimize_strategy}
\usage{
reoptimize_strategy(
  gate,
  channels_subset,
  xp,
  gate_vector,
  level,
  beta = 1,
  verbose = FALSE
)
}
\arguments{
\item{gate}{A return from hypergate}

\item{channels_subset}{Character vector identifying the channels that will be retained (others are ignored). The form is e.g. c("CD4_min","CD8_max")}

\item{xp}{Expression matrix as in the hypergate call}

\item{gate_vector}{Categorical vector as in the hypergate call}

\item{level}{Level of gate_vector identifying the population of interest}

\item{beta}{Yield / purity trade-off}

\item{verbose}{Whether to print information about optimization status}
}
\description{
Optimize a gating strategy given a manual selection of channels
}
\examples{
data(Samusik_01_subset)
xp=Samusik_01_subset$xp_src[,Samusik_01_subset$regular_channels]
gate_vector=Samusik_01_subset$labels
hg=hypergate(xp=xp,gate_vector=gate_vector,level=23,delta_add=0)
contribs=channels_contributions(gate=hg,xp=xp,gate_vector=gate_vector,level=23,beta=1)
significant_channels=names(contribs)[contribs>=0.01]
hg_reoptimized=reoptimize_strategy(gate=hg,channels_subset=significant_channels,xp,gate_vector,23)
}
