% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FLXMRhyreg_het.R
\name{FLXMRhyreg_het}
\alias{FLXMRhyreg_het}
\title{M-step driver to be used in flexmix accounting for heteroscedastisity}
\usage{
FLXMRhyreg_het(
  data,
  formula = . ~ .,
  formula_sigma = formula_sigma,
  family = c("hyreg"),
  type = NULL,
  type_cont = NULL,
  type_dich = NULL,
  variables_both = NULL,
  variables_cont = NULL,
  variables_dich = NULL,
  stv = NULL,
  stv_sigma = NULL,
  offset = NULL,
  opt_method = "BFGS",
  optimizer = "optim",
  lower = -Inf,
  upper = Inf,
  ...
)
}
\arguments{
\item{data}{a \code{data.frame} containing the data, see Details of \link{hyreg2_het}}

\item{formula}{linear model \code{formula}}

\item{formula_sigma}{\code{formula} for estimation of \code{sigma} to account for heteroscedasticity, see Details \link{hyreg2_het}}

\item{family}{default \code{"hyreg"}, needed for \code{\link[flexmix:flexmix]{flexmix::flexmix()}}}

\item{type}{\code{character} vector containing the indicator whether that datapoint (row)
contains continuous or dichotomous data, see Details of \link{hyreg2_het}}

\item{type_cont}{value of \code{type} referring to continuous \code{data}, see Details of \link{hyreg2_het}}

\item{type_dich}{value of \code{type} referring to dichotomous \code{data}, see Details of \link{hyreg2_het}}

\item{variables_both}{\code{character} vector; variables to be fitted on both continuous and dichotomous data.
see Details of \link{hyreg2_het}}

\item{variables_cont}{\code{character} vector; variables to be fitted only on continous data. see Details of \link{hyreg2_het}}

\item{variables_dich}{character vactor; variables to be fitted only on dichotomous data. see Details of \link{hyreg2_het}}

\item{stv}{\verb{named vector} or \code{list} of named vectors containing start values for all coefficients from
\code{formula}, including \code{theta}, see Details of \link{hyreg2_het}}

\item{stv_sigma}{\verb{named vector} with start values for sigma estimation.
Have to be the same variables as given in \code{formula_sigma}, see Details of \link{hyreg2_het}}

\item{offset}{offset as in \code{\link[flexmix:flexmix]{flexmix::flexmix()}}, default \code{NULL}}

\item{opt_method}{\code{character}, optimization method to be used in \code{optimizer}, default \code{"BFGS"}}

\item{optimizer}{\code{character}, optimizer to be used in \code{\link[bbmle:mle2]{bbmle::mle2()}}, default \code{"optim"}}

\item{lower}{lower bound for censored data. If this is used, \code{opt_method} must be
set to \code{"L-BFGS-B"}, default \code{-INF},}

\item{upper}{upper bound for censored data. If this is used, \code{opt_method} must be
set to \code{"L-BFGS-B"},default \code{INF}}

\item{...}{additional arguments for \code{\link[flexmix:flexmix]{flexmix::flexmix()}} or \code{\link[bbmle:mle2]{bbmle::mle2()}}}
}
\value{
a \code{model} object, that can be used in \link{hyreg2_het} as input for parameter \code{model} in \code{\link[flexmix:flexmix]{flexmix::flexmix()}}
}
\description{
Function used in flexmix M-Step to estimate hybrid model accounting for heteroscedastisity
}
\examples{

formula <- y ~  -1 + x1 + x2 + x3
formula_sigma <- y ~ x1 + x2 + x3
stv <- setNames(c(0.2,0,1,1),c(colnames(simulated_data_norm)[3:5],c("theta")))
stv_sigma <- setNames(c(0.2,0.2,0.1,1),c(colnames(simulated_data_norm)[3:5],c("(Intercept)")))


x <- model.matrix(formula,simulated_data_norm)
y <- simulated_data_norm$y
w <- 1
model <- FLXMRhyreg_het( data = simulated_data_norm,
                     formula = formula,
                     formula_sigma = formula_sigma,
                    family=c("hyreg"),
                    type =  simulated_data_norm$type,
                    stv = stv,
                    stv_sigma = stv_sigma,
                    type_cont = "TTO",
                    type_dich = "DCE_A",
                    opt_method = "L-BFGS-B",
                    control = list(iter.max = 1000, verbose = 4),
                    offset = NULL,
                    optimizer = "optim",
                    variables_both =  names(stv)[!is.element(names(stv),c("theta"))],
                    variables_cont = NULL,
                    variables_dich = NULL,
                    lower = -Inf,
                    upper = Inf,
)
}
\author{
Svenja Elkenkamp and Kim Rand
}
