#' Limited Nomination formula
#'
#' @rdname ElecFuns
#'
#' @section Details: The lim_nom function is used to calculate the seats obtained 
#' with closed-list plurality with limited nomination system. Voters only get
#' one vote, which is cast for a closed party list. District magnitude needs
#' to be 3 (i.e., M=3) and the top vote-getting party is awarded two seats 
#' while the third seat goes to the second-place finisher — even if its level 
#' of support is abysmally low.
#' 
#' @export
#'
#' @examples
#' 
#' ## Lim_nom (only works with m=3)
#' 
#' lim_nom(v=example, m=3)
#' 
lim_nom <- function(v, m,  ...){
  if(m != 3){
    stop("Limited nomination only defined for M = 3")
  }
  if(nrow(v) > 1){
    stop("Limited nomination undefined for ranked votes.")
  }
  which_top <- max_n(v, 2)
  seats <- rep(0, length(v))
  names(seats) <- colnames(v)
  seats[which_top[1]] <- 2
  seats[which_top[2]] <- 1
  return(seats)
}