% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iBART.R
\name{iBART}
\alias{iBART}
\title{iBART descriptor selection}
\usage{
iBART(
  X = NULL,
  y = NULL,
  head = NULL,
  unit = NULL,
  BART_var_sel_method = "global_se",
  num_trees = 20,
  num_burn_in = 10000,
  num_iterations_after_burn_in = 5000,
  num_reps_for_avg = 10,
  num_permute_samples = 50,
  type.measure = "deviance",
  nfolds = 10,
  nlambda = 100,
  relax = FALSE,
  gamma = c(0, 0.25, 0.5, 0.75, 1),
  opt = c("binary", "unary", "binary"),
  sin_cos = FALSE,
  apply_pos_opt_on_neg_x = TRUE,
  hold = 0,
  pre_screen = TRUE,
  corr_screen = TRUE,
  out_sample = FALSE,
  train_idx = NULL,
  train_ratio = 1,
  Lzero = TRUE,
  parallel = FALSE,
  K = ifelse(Lzero, 5, 0),
  aic = FALSE,
  standardize = TRUE,
  writeLog = FALSE,
  verbose = TRUE,
  count = NULL,
  seed = NULL
)
}
\arguments{
\item{X}{Input matrix of primary features \eqn{X}.}

\item{y}{Response variable \eqn{y}.}

\item{head}{Optional: name of primary features.}

\item{unit}{Optional: units and their respective dimensions of primary features. This is used to perform dimension analysis for generated descriptors to avoid generating unphyiscal descriptors, such as \eqn{size + size^2}. See \code{generate_dimension()} for details.}

\item{BART_var_sel_method}{Variable selection criterion used in BART. Three options are available: (1) "global_se", (2) "global_max", (3) "local". The default is "global_se". See \code{var_selection_by_permute} in \code{R} package \code{bartMachine} for more detail.}

\item{num_trees}{BART parameter: number of trees to be grown in the sum-of-trees model. If you want different values for each iteration of BART, input a vector of length equal to number of iterations. Default is \code{num_trees = 20}.}

\item{num_burn_in}{BART parameter: number of MCMC samples to be discarded as ``burn-in". If you want different values for each iteration of BART, input a vector of length equal to number of iterations. Default is \code{num_burn_in = 10000}.}

\item{num_iterations_after_burn_in}{BART parameter: number of MCMC samples to draw from the posterior distribution of \eqn{hat{f}(x)}. If you want different values for each iteration of BART, input a vector of length equal to number of iterations. Default is \code{num_iterations_after_burn_in = 5000}.}

\item{num_reps_for_avg}{BART parameter: number of replicates to over over to for the BART model's variable inclusion proportions. If you want different values for each iteration of BART, input a vector of length equal to number of iterations. Default is \code{num_reps_for_avg = 10}.}

\item{num_permute_samples}{BART parameter: number of permutations of the response to be made to generate the “null” permutation distribution. If you want different values for each iteration of BART, input a vector of length equal to number of iterations. Default is \code{num_permute_samples = 50}.}

\item{type.measure}{\code{glmnet} parameter: loss to use for cross-validation. The default is \code{type.measure="deviance"}, which uses squared-error for Gaussian models (a.k.a \code{type.measure="mse" there}). \code{type.measure="mae"} (mean absolute error) can be used also.}

\item{nfolds}{\code{glmnet} parameter: number of folds - default is 10. Smallest value allowable is \code{nfolds=3}.}

\item{nlambda}{\code{glmnet} parameter: the number of \code{lambda} values - default is 100.}

\item{relax}{\code{glmnet} parameter: If \code{TRUE}, then CV is done with respect to the mixing parameter \code{gamma} as well as \code{lambda}. Default is \code{relax=FALSE}.}

\item{gamma}{\code{glmnet} parameter: the values of the parameter for mixing the relaxed fit with the regularized fit, between 0 and 1; default is \code{gamma = c(0, 0.25, 0.5, 0.75, 1)}}

\item{opt}{A vector of operation order. For example, \code{opt = c("unary", "binary", "unary")} will apply unary operators, then binary operators, then unary operators. Available operator sets are \code{"unary"}, \code{"binary"}, and \code{"all"}, where \code{"all"} is the union of \code{"unary"} and \code{"binary"}.}

\item{sin_cos}{Logical flag for using \eqn{sin(\pi*x)} and \eqn{cos(\pi*x)} to generate descriptors. This is useful if you think there is periodic relationship between predictors and response. Default is \code{sin_cos = FALSE}.}

\item{apply_pos_opt_on_neg_x}{Logical flag for applying non-negative-valued operators, such as \eqn{\sqrt x} and \eqn{log(x)}, when some values of \eqn{x} is negative. If \code{apply_pos_opt_on_neg_x == TRUE}, apply absolute value operator first then non-negative-valued operator, i.e. generate \eqn{\sqrt |x|} and \eqn{log(|x|)} instead. Default is \code{apply_pos_opt_on_neg_x = TRUE}.}

\item{hold}{Number of iterations to hold. This allows iBART to run consecutive operator transformations before screening. Note \code{hold = 0} is equivalent to no skipping of variable selection in each iBART iterations. It should be less than \code{iter}.}

\item{pre_screen}{Logical flag for pre-screening the primary features X using BART. Only selected primary features will be used to generate descriptors. Note that \code{pre_screen = FALSE} is equivalent to \code{hold = 1}.}

\item{corr_screen}{Logical flag for screening out primary features that are independet of the response variable \eqn{y}.}

\item{out_sample}{Logical flag for out of sample assessment. Default is \code{out_sample = FALSE}.}

\item{train_idx}{Numerical vector storing the row indices for training data. Please set \code{out_sample = TRUE} if you supplied \code{train_idx}.}

\item{train_ratio}{Proportion of data used to train model. Value must be between (0,1]. This is only needed when \code{out_sample = TRUE} and \code{train_idx == NULL}. Default is \code{train_ratio = 1}.}

\item{Lzero}{Logical flag for L-zero variable selection. Default is \code{Lzero = TRUE}.}

\item{parallel}{Logical flag for parallel L-zero variable selection. Default is \code{parallel = FALSE}.}

\item{K}{If \code{Lzero == TRUE}, \code{K} sets the maximum number of descriptors to be selected.}

\item{aic}{If \code{Lzero == TRUE}, logical flag for selecting best number of descriptors using AIC. Possible number of descriptors are \eqn{1 \le k \le K}.}

\item{standardize}{Logical flag for data standardization prior to model fitting in BART and LASSO. Default is \code{standardize = TRUE}.}

\item{writeLog}{Logical flag for writing log file to working directory. The log file will contain information such as the descriptors selected by iBART, RMSE of the linear model build on the selected descriptors, etc. Default is \code{writeLog = FALSE}.}

\item{verbose}{Logical flag for printing progress to console. Default is \code{verbose = TRUE}.}

\item{count}{Internal parameter. Default is \code{count = NULL}.}

\item{seed}{Optional: sets the seed in both R and Java. Default is \code{seed = NULL} which does not set the seed in R nor Java.}
}
\value{
A list of iBART output.
\item{iBART_model}{The LASSO output of the last iteration of iBART. The predictors with non-zero coefficient are called the iBART selected descriptors.}
\item{X_selected}{The numerical values of the iBART selected descriptors.}
\item{descriptor_names}{The names of the iBART selected descriptors.}
\item{coefficients}{Coefficients of the iBART model. The first element is an intercept.}
\item{X_train}{The training matrix used in the last iteration.}
\item{X_test}{The testing matrix used in the last iteration.}
\item{iBART_gen_size}{The number of descriptors generated by iBART in each iteration.}
\item{iBART_sel_size}{The number of descriptors selected by iBART in each iteration.}
\item{iBART_in_sample_RMSE}{In sample RMSE of the LASSO model.}
\item{iBART_out_sample_RMSE}{Out of sample RMSE of the LASSO model if \code{out_sample == TRUE}.}
\item{Lzero_models}{The \eqn{l_0}-penalized regression models fitted on the iBART selected descriptors for \eqn{1 \le k \le K}.}
\item{Lzero_names}{The name of the best \eqn{k}D descriptors selected by the \eqn{l_0}-penalized regression model for \eqn{1 \le k \le K}.}
\item{Lzero_in_sample_RMSE}{In sample RMSE of the \eqn{l_0}-penalized regression model for \eqn{1 \le k \le K}.}
\item{Lzero_out_sample_RMSE}{Out of sample RMSE of the \eqn{l_0}-penalized regression model for \eqn{1 \le k \le K} if \code{out_sample == TRUE}.}
\item{Lzero_AIC_model}{The best \eqn{l_0}-penalized regression model selected by AIC.}
\item{Lzero_AIC_names}{The best \eqn{k}D descriptors where \eqn{1 \le k \le K} is chosen via AIC.}
\item{Lzero_AIC_in_sample_RMSE}{In sample RMSE of the best \eqn{l_0}-penalized regression models chosen by AIC.}
\item{Lzero_AIC_out_sample_RMSE}{Out of sample RMSE of the best \eqn{l_0}-penalized regression models chosen by AIC if \code{out_sample == TRUE}.}
\item{runtime}{Runtime in second.}
}
\description{
Finds a symbolic formula for the regression function \eqn{y=f(X)} using \eqn{(y,X)} as inputs.
}
\references{
Ye, S., Senftle, T.P., and Li, M. (2023) \emph{Operator-induced structural variable selection for identifying materials genes}, \url{https://arxiv.org/abs/2110.10195}.
}
\author{
Shengbin Ye
}
