% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathways.R
\name{iCARH.getPathwaysMat}
\alias{iCARH.getPathwaysMat}
\title{Builds pathways adjacency matrices}
\usage{
iCARH.getPathwaysMat(keggid, org)
}
\arguments{
\item{keggid}{KEGG identifiers as specified in KEGG.
keggid is list that might contain multiple identifiers per metabolite.}

\item{org}{organism}
}
\value{
list of pathway matrices based on shortest paths between two metabolites
}
\description{
Builds pathways adjacency matrices from specified KEGG identifiers.
Returns a list of pathway adjacency matrices based on shortest paths.
}
\examples{
keggid = list("C08363")
iCARH.getPathwaysMat(keggid, "rno")
gc()
\donttest{keggid = list("Unk1", "C00350",c("C08363", "C01245"))
iCARH.getPathwaysMat(keggid, "rno")
gc()}

}
