% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gm_umeyama.R
\name{graph_match_Umeyama}
\alias{graph_match_Umeyama}
\title{Spectral Graph Matching Methods: Umeyama Algorithm}
\usage{
graph_match_Umeyama(A, B, seeds = NULL, similarity = NULL)
}
\arguments{
\item{A}{A matrix, igraph object, or list of either.}

\item{B}{A matrix, igraph object, or list of either.}

\item{seeds}{A vector of integers or logicals, a matrix or a data frame. If
the seed pairs have the same indices in both graphs then seeds can be a
vector. If not, seeds must be  a matrix
or a data frame, with the first column being the indices of \eqn{G_1} and
the second column being the corresponding indices of \eqn{G_2}.}

\item{similarity}{A matrix. An \code{n-by-n} matrix containing vertex similarities.}
}
\value{
\code{graph_match_Umeyama} returns an object of class "\code{\link{graphMatch}}" which is a list
  containing the following components:

  \describe{
    \item{corr_A}{matching correspondence in \eqn{G_1}}
    \item{corr_B}{matching correspondence in \eqn{G_2}}
    \item{soft}{the functional similarity score matrix with which one can extract
      more than one matching candidates}
    \item{lap_method}{Choice for solving the LAP}
    \item{seeds}{a vector of logicals indicating if the corresponding vertex is a seed}
  }
}
\description{
Spectral Graph Matching Methods: Umeyama Algorithm
}
\examples{
# match G_1 & G_2 using Umeyama algorithm
G <- sample_correlated_gnp_pair(10, .9, .5)
g1 <- G$graph1
g2 <- G$graph2
startm <- matrix(0, 10, 10)
diag(startm)[1:4] <- 1

GM_Umeyama <- gm(g1, g2, similarity = startm, method = "Umeyama")
GM_Umeyama
# generate the corresponding permutation matrix
GM_Umeyama[]

summary(GM_Umeyama, g1, g2)
# visualize the edge-wise matching performance
plot(g1, g2, GM_Umeyama)
plot(g1[], g2[], GM_Umeyama)


}
\references{
S. Umeyama (1988), \emph{An eigendecomposition approach to weighted
  graph matching problems}. IEEE TPAMI. USA, pages 695-703.
}
\keyword{internal}
