% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limitsOfAgreement.R
\name{limitsOfAgreement}
\alias{limitsOfAgreement}
\alias{laWRBM}
\alias{laBRWM}
\alias{laWRWM}
\alias{laBRBM}
\title{MRMC Analysis of Limits of Agreement using ANOVA}
\usage{
laWRBM(
  df,
  modalitiesToCompare = c("testA", "testB"),
  keyColumns = c("readerID", "caseID", "modalityID", "score"),
  if.aov = TRUE,
  type = 1,
  reader.first = TRUE
)

laBRWM(
  df,
  modality = c("testA"),
  keyColumns = c("readerID", "caseID", "modalityID", "score"),
  if.aov = TRUE,
  type = 1,
  reader.first = TRUE
)

laWRWM(
  df,
  replicatesToCompare = c("testA", "testB"),
  keyColumns = c("readerID", "caseID", "modalityID", "score"),
  if.aov = TRUE,
  type = 1,
  reader.first = TRUE
)

laBRBM(
  df,
  modalitiesToCompare = c("testA", "testB"),
  keyColumns = c("readerID", "caseID", "modalityID", "score"),
  if.aov = TRUE,
  type = 1,
  reader.first = TRUE,
  is.sparseQR = T
)
}
\arguments{
\item{df}{Data frame of observations, one per row. Columns identify random effects, fixed effects,
and the observation. Namely,
\describe{
  \item{readerID}{The factor corresponding to the different readers in the study.
    The readerID is treated as a random effect.}
  \item{caseID}{The factor corresponding to the different cases in the study.
    The caseID is treated as a random effect.}
  \item{modalityID}{The factor corresponding to the different modalities in the study.
    The modalityID is treated as a fixed effect.}
  \item{score}{The number (observation) given by the reader to the case for the modality indicated.}
}}

\item{modalitiesToCompare}{The factors identifying the modalities to compare. It should be length 2.
Default = \code{c("testA","testB")}}

\item{keyColumns}{Identify the factors corresponding to the readerID (random effect), caseID (random effect),
modalityID (fixed effect), and score (observation).
Default = \code{c("readerID", "caseID", "modalityID", "score")}}

\item{if.aov}{Boolean value to determine whether to use the `stats::aov` function or to
calculate the ANOVA statistics explicitly. `stats::aov` is only appropriate
for fully-crossed study only. This flag permits head-to-head comparisons of
the output from `stats::aov` and the explicit calculations.
Default = \code{TRUE}}

\item{type}{Identify how SS are computed in ANOVA for unbalanced study designs.
The possible values are c(1,2,3), corresponding to the approaches
introduced in the SAS package(Langsrud2003_Stat-Comput_v13p163).

Default \code{type= 1}}

\item{reader.first}{Boolean value to determine whether reader effect is added to the model before the case effect. 
Default \code{reader.first = TRUE}}

\item{modality}{The factor identifying the modality for laBRWM. It should be length 1.
Default = \code{modality = c("testA")}}

\item{replicatesToCompare}{The factors identifying the replicates to compare for \code{laWRWM}. It should be length 2.
Default = \code{c("testA","testB")}}

\item{is.sparseQR}{Boolean value to determine whether the `base::qr` function assumes the input
data is sparse or not. 
Default = \code{TRUE}}
}
\value{
A list of two dataframes.

The first dataframe is \code{limits.of.agreement}. It has one row. Each column is as follows:
\describe{
  \item{meanDiff}{The mean difference score.}
  \item{var.MeanDiff}{The variance of the mean difference score.}
  \item{var.1obs}{The variance of the difference score.}
  \item{ci95meanDiff.bot}{Lower bound of 95\% CI for the mean difference score. \code{meanDiff+
  1.96*sqrt(var.MeanDiff)}}
  \item{ci95meanDiff.top}{Upper bound of 95\% CI for the mean difference score. \code{meanDiff-
  1.96*sqrt(var.MeanDiff)}}
  \item{la.bot}{Lower Limit of Agreement for the difference score. \code{meanDiff+1.96*sqrt(var.1obs)}}
  \item{la.top}{Upper Limit of Agreement for the difference score. \code{meanDiff-1.96*sqrt(var.1obs)}}
}

The second dataframe is \code{two.way.ANOVA} or \code{three.way.ANOVA} shows the degrees of freedom, 
sums of squares, and estimates of variance components for each source of variation
}
\description{
These four functions calculate four types of Limits of Agreement using ANOVA: 
Within-Reader Within-Modality(WRWM), Between-Reader Within-Modality(BRWM),
Within-Reader Between-Modality(WRBM), and Between-Reader Between-Modality(BRBM). 
The 95\% confidence interval of the mean difference is also provided. If the study is fully crossed, the ANOVA 
methods are realized either by applying \code{stats::aov} or by matrix multiplication. Otherwise, the SS in ANOVA are
computed as residual sums of squares of linear models. See details below about the model structure
and these references.

\itemize{
  \item S. Wen and B. D. Gallas,
    “Three-Way Mixed Effect ANOVA to Estimate MRMC Limits of Agreement,”
    \emph{Statistics in Biopharmaceutical Research}, \strong{14}, pp. 532–541, 2022,
    \doi{10.1080/19466315.2022.2063169}.
  \item S. Wen and B. D. Gallas,
    “Expanding to Arbitrary Study Designs: ANOVA to Estimate Limits of Agreement for MRMC Studies,”
    \emph{arXiv}, 2023, \doi{10.48550/ARXIV.2312.16097}.
}
}
\details{
Suppose the score from a reader j for case k under modality \eqn{i} is\eqn{X_{ijk}}, then the difference score from the
same reader for the same case under two different modalities is \eqn{Y_{jk} = X_{1jk} - X_{2jk}}.
\itemize{
  \item\code{laWRBM} use two-way random effect ANOVA to analyze the difference scores \eqn{Y_{jk}}. The model
  is \eqn{Y_{jk}=\mu + R_j + C_k + \epsilon_{jk}}, where \eqn{R_j} and \eqn{C_k} are random effects for readers
  and cases. The variances of mean and individual observations are expressed as linear combinations of the MS
  given by ANOVA.
  \item\code{laBRWM} use two-way random effect ANOVA to analyze the scores \eqn{X_{jk}} for a single modality. 
  The model is \eqn{X_{jk}=\mu + R_j + C_k + \epsilon_{jk}}, where \eqn{R_j} and \eqn{C_k} are random effects 
  for readers and cases. The variances of mean and individual observations are expressed as linear combinations 
  of the MS given by ANOVA.
  \item\code{laWRWM} use two-way random effect ANOVA to analyze the difference scores \eqn{Y_{jk}} from the same 
  reader for the same cases under the same modality with different replicates \eqn{Y_{jk} = X_{jk1} - X_{jk2}}. 
  The model is \eqn{Y_{jk}=\mu + R_j + C_k + \epsilon_{jk}}, where \eqn{R_j} and \eqn{C_k} are random effects for 
  readers and cases. The variances of mean and individual observations are expressed as  linear combinations of 
  the MS given by ANOVA.
  \item\code{laBRBM} use three-way mixed effect ANOVA to analyze the scores \eqn{X_{ijk}}. The model is given by
  \eqn{X_{ijk}=\mu + R_j + C_k + m_i + RC_{jk} + mR_{ij} + mC_{ik} + \epsilon_{ijk}}, where \eqn{R_j} and
  \eqn{C_k} are random effects for readers and cases, \eqn{m_i} is a fixed effect for modality, and the other terms
  are interaction terms. The variances of mean and individual observations are expressed as linear combinations
  of the MS given by ANOVA.
}
}
\examples{
# Initialize the simulation configuration parameters
config <- sim.NormalIG.Hierarchical.config(modalityID = c("testA", "testB"))

# Initizlize the seed and stream of the random number generator
init.lecuyerRNG()

# Simulate an MRMC ROC data set
dFrame <- sim.NormalIG.Hierarchical(config)

# Compute Limits of Agreement
laWRBM_result <- laWRBM(dFrame)
print(laWRBM_result)
laBRBM_result <- laBRBM(dFrame)
print(laBRBM_result)

}
