% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MainFun.R
\name{Evenness}
\alias{Evenness}
\title{Main function for STEP 4: Assessment of evenness}
\usage{
Evenness(
  data,
  q = seq(0, 2, 0.2),
  datatype = "abundance",
  method = "Estimated",
  nboot = 30,
  conf = 0.95,
  nT = NULL,
  E.class = 1:5,
  SC = NULL
)
}
\arguments{
\item{data}{(a) For \code{datatype = "abundance"}, data can be input as a vector of species abundances (for a single assemblage), matrix/data.frame (species by assemblages), or a list of species abundance vectors. \cr
(b) For \code{datatype = "incidence_raw"}, data can be input as a list of matrix/data.frame (species by sampling units); data can also be input as a matrix/data.frame by merging all sampling units across assemblages based on species identity; in this case, the number of sampling units (nT, see below) must be input.}

\item{q}{a numerical vector specifying the orders of evenness. Default is \code{seq(0, 2, by = 0.2)}.}

\item{datatype}{data type of input data: individual-based abundance data (\code{datatype = "abundance"}) or species by sampling-units incidence matrix (\code{datatype = "incidence_raw"}) with all entries being 0 (non-detection) or 1 (detection).}

\item{method}{a binary selection of method with \code{"Estimated"} (evenness is computed under a standardized coverage value) or \code{"Observed"} (evenness is computed for the observed data).\cr}

\item{nboot}{a positive integer specifying the number of bootstrap replications when assessing sampling uncertainty and constructing confidence intervals. Enter 0 to skip the bootstrap procedures. Default is \code{30}.}

\item{conf}{a positive number < \code{1} specifying the level of confidence interval. Default is \code{0.95}.}

\item{nT}{(required only when \code{datatype = "incidence_raw"} and input data is matrix/data.frame) a vector of nonnegative integers specifying the number of sampling units in each assemblage. If assemblage names are not specified, then assemblages are automatically named as "Assemblage1", "Assemblage2",..., etc.}

\item{E.class}{an integer vector between 1 to 5 specifying which class(es) of evenness measures are selected; default is 1:5 (select all five classes).}

\item{SC}{(required only when \code{method = "Estimated"}) a standardized coverage value for calculating estimated evenness. If \code{SC = NULL}, then this function computes the diversity estimates for the minimum sample coverage among all samples extrapolated to double reference sizes (Cmax).}
}
\value{
A list of several tables containing estimated (or observed) evenness with order q.\cr
        Each tables represents a class of evenness.
        \item{Order.q}{the order of evenness}
        \item{Evenness}{the computed evenness value of order q.}
        \item{s.e.}{standard error of evenness value.}
        \item{Even.LCL, Even.UCL}{the bootstrap lower and upper confidence limits for the evenness of order q at the specified level (with a default value of \code{0.95}).}
        \item{Assemblage}{the assemblage name.}
        \item{Method}{\code{"Estimated"} or \code{"Observed"}.}
        \item{SC}{the standardized coverage value under which evenness values are computed (only for \code{method = "Estimated"})}
}
\description{
\code{Evenness} computes standardized and observed evenness of order q = 0 to q = 2 in increments of 0.2 (by default) and depicts evenness profiles based on five classes of evenness measures developed 
in Chao and Ricotta (2019). Note that for q = 0 species abundances are disregarded, so it is not meaningful to evaluate evenness among abundances specifically for q = 0. As q tends to 0, all evenness values tend to 1 as a limiting value.
}
\examples{
## Evenness for abundance data
# The observed evenness values for abundance data
data(Data_spider)
Even_out1_obs <- Evenness(data = Data_spider, datatype = "abundance", 
                          method = "Observed", E.class = 1:5)
Even_out1_obs

\donttest{
# Estimated evenness for abundance data with default sample coverage value
data(Data_spider)
Even_out1_est <- Evenness(data = Data_spider, datatype = "abundance", 
                          method = "Estimated", SC = NULL, E.class = 1:5)
Even_out1_est
}

## Evenness for incidence raw data
# The observed evenness values for incidence raw data
data(Data_woody_plant)
Even_out2_obs <- Evenness(data = Data_woody_plant, datatype = "incidence_raw", 
                          method = "Observed", E.class = 1:5)
Even_out2_obs

\donttest{
# Estimated evenness for incidence data with user's specified coverage value of 0.98
data(Data_woody_plant)
Even_out2_est <- Evenness(data = Data_woody_plant, datatype = "incidence_raw", 
                          method = "Estimated", SC = 0.98, E.class = 1:5)
Even_out2_est
}

}
\references{
Chao, A. and Ricotta, C. (2019). Quantifying evenness and linking it to diversity, beta diversity, and similarity. Ecology, 100(12), e02852.
}
