% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecastplot.R
\name{log_if}
\alias{log_if}
\title{Apply logarithmic transformation}
\usage{
log_if(x, mult_fit)
}
\arguments{
\item{x}{A numeric vector to be transformed.}

\item{mult_fit}{Logical; set to TRUE to apply logarithmic transformation,
and FALSE to keep the original input.}
}
\value{
A \code{numeric} vector after applying the logarithmic transformation (if
\code{mult_fit = TRUE}); otherwise, it returns the original input.
}
\description{
Log-transforms the input \code{x} if \code{mult_fit} is TRUE; otherwise, returns the
original input \code{x} unchanged.
}
\examples{
x <- runif(1e4, 1, 100)
all.equal(log_if(x, TRUE), log(x))
all.equal(log_if(x, FALSE), x)

}
\seealso{
\code{\link[fabletools]{new_transformation}}
}
