% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spls.R
\name{spls}
\alias{spls}
\title{Sparse partial least squares}
\usage{
spls(x, y, mu1, eps = 1e-04, kappa = 0.05, scale.x = TRUE,
  scale.y = TRUE, maxstep = 50, trace = FALSE)
}
\arguments{
\item{x}{matrix of explanatory variables.}

\item{y}{matrix of dependent variables.}

\item{mu1}{numeric, sparsity penalty parameter.}

\item{eps}{numeric, the threshold at which the algorithm terminates.}

\item{kappa}{numeric, 0 < kappa < 0.5 and the parameter reduces the effect of the concave part of objective function.}

\item{scale.x}{character, "TRUE" or "FALSE", whether or not to scale the variables x. The default is TRUE.}

\item{scale.y}{character, "TRUE" or "FALSE", whether or not to scale the variables y. The default is TRUE.}

\item{maxstep}{numeric, maximum iteration steps. The default value is 50.}

\item{trace}{character, "TRUE" or "FALSE". If TRUE, prints out its screening results of variables.}
}
\value{
An 'spls' object that contains the list of the following items.
\itemize{
\item{x:}{ data matrix of explanatory variables with centered columns. If scale.x is TRUE, the columns of data matrix are standardized to have mean 0 and standard deviation 1.}
\item{y:}{ data matrix of dependent variables with centered columns. If scale.y is TRUE, the columns of data matrix are standardized to have mean 0 and standard deviation 1.}
\item{betahat:}{ the estimated regression coefficients.}
\item{loading:}{ the estimated first direction vector.}
\item{variable:}{ the screening results of variables.}
\item{meanx:}{ column mean of the original dataset x.}
\item{normx:}{ column standard deviation of the original dataset x.}
\item{meany:}{ column mean of the original dataset y.}
\item{normy:}{ column standard deviation of the original dataset y.}
}
}
\description{
This function provides penalty-based sparse partial least squares analysis for single dataset with high dimensions., which aims to have the direction of the first loading.
}
\examples{
library(iSFun)
data("simData.pls")
x.spls <- do.call(rbind, simData.pls$x)
y.spls <- do.call(rbind, simData.pls$y)
res_spls <- spls(x = x.spls, y = y.spls, mu1 = 0.05, eps = 1e-3, kappa = 0.05,
                 scale.x = TRUE, scale.y = TRUE, maxstep = 50, trace = FALSE)
}
\seealso{
See Also as \code{\link{ispls}}, \code{\link{meta.spls}}.
}
