% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iaibase.R
\name{predict.supervised_multi_learner}
\alias{predict.supervised_multi_learner}
\title{Return the predictions made by a multi-task supervised learner for each point in the features}
\usage{
\method{predict}{supervised_multi_learner}(obj, X, ...)
}
\arguments{
\item{obj}{The learner or grid to use for prediction.}

\item{X}{The features of the data.}

\item{...}{Refer to the Julia documentation for available parameters.}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.2.2/IAIBase/reference/#IAI.predict-Tuple\%7BLearner\%7BIAIBase.MultiTask\%7BT\%7D\%7D\%20where\%20T\%3C\%3AIAIBase.SupervisedTask\%2C\%20Union\%7BDataFrames.AbstractDataFrame\%2C\%20AbstractMatrix\%7B\%3C\%3AReal\%7D\%7D\%7D}{\code{IAI.predict}}
and
\href{https://docs.interpretable.ai/v3.2.2/IAIBase/reference/#IAI.predict-Tuple\%7BLearner\%7BIAIBase.MultiTask\%7BT\%7D\%7D\%20where\%20T\%3C\%3AIAIBase.SupervisedTask\%2C\%20Union\%7BDataFrames.AbstractDataFrame\%2C\%20AbstractMatrix\%7B\%3C\%3AReal\%7D\%7D\%2C\%20Symbol\%7D}{\code{IAI.predict}}
}
\section{IAI Compatibility}{

Requires IAI version 3.2 or higher.
}

\examples{
\dontrun{iai::predict(lnr, X)}

}
