% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iarm.R
\docType{package}
\name{iarm-package}
\alias{iarm-package}
\alias{iarm}
\title{iarm: A package for item analysis in Rasch models}
\description{
Tools to assess model fit and identify misfitting items for Rasch models (RM) and partial
credit models (PCM). Included are item fit statistics, item-restscore association,
conditional likelihood ratio tests, assessment of measurement error, estimates of the reliability and test targeting.
}
\section{Item Fit statistics}{

Item fit statistics are used to assess whether individual items fit the Rasch model.
Outfit and infit  mean squares are well-known and much used statistics.
 They summarize standardized response residuals comparing observed responses to items
 to the expected responses.  To avoid bias expected responses are calculated under the
 conditional distribution of responses given the total score. Parametric bootstrapping is used to assess
 the significance of misfitting items. The item restscore gamma coefficient
 is used to assess differential item discrimination.
}

\section{Conditional likelihood ratio tests (CLR)}{

The conditional likelihood ratio test of Andersen is an overall test of fit of data to the model.
The test compares conditional maximum likelihood estimates of item parameters in different subgroups
to the estimates for the complete sample of persons. Subgroups are defined by outcomes of the total
score (test of homogeneity) or by outcomes of an exogenous variable (test of no differential item
functioning, DIF).
}

\references{
Andersen, E. B. (1973) A goodness of fit test for the Rasch model.
\emph{Psychometrika}, 38, 123-140.

Kreiner, S. & Christensen, K. B. (2011) Exact evaluation of Bias in Rasch model residuals.
\emph{Advances in Mathematics Research}, 12, 19-40.

Mueller, M. & Kreiner, S. (2015) Item Fit Statistics in Common Software for Rasch Analysis. Research Report 15-06, Department of Biostatistics, University of Copenhagen.
}
