% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkInputs.R
\name{checkSurveyYearQuarterOK}
\alias{checkSurveyYearQuarterOK}
\title{Check that a survey, year and quarter combination is in the database}
\usage{
checkSurveyYearQuarterOK(
  survey,
  year,
  quarter,
  checksurvey = TRUE,
  checkyear = TRUE
)
}
\arguments{
\item{survey}{the survey acronym, e.g. NS-IBTS.}

\item{year}{the year of the survey, e.g. 2010.}

\item{quarter}{the quarter of the year the survey took place, i.e. 1, 2, 3 or 4.}

\item{checksurvey}{logical, should the survey name also be checked.}

\item{checkyear}{logical, should the year also be checked.}
}
\value{
logical.
}
\description{
Checks a quarter and/or year and/or survey name against a list of all survey year quarter
combinations in the DATRAS database.
If the combination is not matched it puts up a message showing the available options.
}
\examples{
\dontrun{
checkSurveyYearQuarterOK(survey = "ROCKALL", 2015, 3)
checkSurveyYearQuarterOK(survey = "ROCKALL", 2015, 1)
checkSurveyYearQuarterOK(survey = "ROCKALL", 2000, 1)
checkSurveyYearQuarterOK(survey = "NOTALL", 2000, 1)

# be careful of unexpected results with checksurvey and checkyear!
checkSurveyYearQuarterOK(survey = "NOTALL", 2000, 1, checksurvey=FALSE)
}
}
\seealso{
\code{\link{checkSurveyOK}} and \code{\link{checkSurveyYearOK}}
 also perform checks against the DATRAS database.

\code{\link{icesDatras-package}} gives an overview of the package.
}
