% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iclogcondist_simulation.R
\name{simulate_ic_data}
\alias{simulate_ic_data}
\title{Simulate Interval-Censored Data}
\usage{
simulate_ic_data(
  n,
  dist,
  para1,
  para2,
  upper_bound = Inf,
  C1_upper = 1,
  case = 2,
  rounding = FALSE,
  round_digit = 4
)
}
\arguments{
\item{n}{An integer specifying the number of observations to generate.}

\item{dist}{A character string indicating the distribution to use for event times. 
Options are \code{"lognormal"}, \code{"weibull"}, or \code{"loglogistic"}.}

\item{para1}{A numeric value representing the first parameter of the distribution:
\itemize{
  \item \code{"lognormal"}: Mean of the log-normal distribution (meanlog).
  \item \code{"weibull"} and \code{"loglogistic"}: Shape parameter.
}}

\item{para2}{A numeric value representing the second parameter of the distribution:
\itemize{
  \item \code{"lognormal"}: Standard deviation of the log-normal distribution (sdlog).
  \item \code{"weibull"} and \code{"loglogistic"}: Scale parameter.
}}

\item{upper_bound}{A numeric value specifying the upper bound for event times, 
corresponding to a truncated distribution. Default is \code{Inf}.}

\item{C1_upper}{A numeric value specifying the upper limit for the first censoring time \code{C1}. 
Default is 1.}

\item{case}{An integer specifying the censoring case to simulate:
\itemize{
  \item \code{1}: Current status (case 1 interval censoring)
  \item \code{2}: Case 2 Interval censoring
}}

\item{rounding}{A logical value. If \code{TRUE}, generated times are rounded to a specified number of decimal places. Default is \code{FALSE}.}

\item{round_digit}{An integer specifying the number of digits for rounding when \code{rounding = TRUE}. Default is 4.}
}
\value{
A matrix of interval-censored data where each row represents an interval (L, R] containing the unobserved event time.
}
\description{
This function generates interval-censored data, where the event times
are generated from one of the following distributions: Weibull, log-normal and log-logistic.
It supports both case 1 and case 2 interval censoring.
}
\details{
\itemize{
  \item **Censoring Times**:
        \itemize{
          \item In \code{case = 1} (current status), one censoring time is generated, where it follows \code{U(0, C1_upper)}.
          \item In \code{case = 2} (case 2 interval censoring), two censoring times are generated:
                \itemize{
                  \item \code{C1}: sampled from \code{U(0, C1_upper)}.
                  \item \code{C2}: sampled from \code{U(C1, min(upper_bound, 20))}.
                }
        }
  \item **Distributions**:
        \itemize{
          \item **Weibull**: Parameterized by shape (\code{para1}) and scale (\code{para2}).
          \item **Log-logistic**: Parameterized by shape (\code{para1}) and scale (\code{para2}).
          \item **Log-normal**: Parameterized by mean (\code{para1}) and standard deviation (\code{para2}).
        }
}
}
\examples{
# Simulate data with a truncated Weibull distribution and case II interval censoring
simulate_ic_data(n = 100, dist = "weibull", para1 = 2, para2 = 1, upper_bound = 5, case = 2)
}
