% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_solver.R
\name{EM_solver}
\alias{EM_solver}
\title{EM solver for extended illness-death model (Frydman 1995)}
\usage{
EM_solver(data_idx, supportMSM, z, lambda, tol = 1e-08)
}
\arguments{
\item{data_idx}{List containing data, outputted from \code{\link{msm_frydman}}}

\item{supportMSM}{List containing data on the support of the 1->2 transition,
output from supportMSM()}

\item{z}{Initial values for \eqn{F_{12}}{F_(12)} and \eqn{F_{13}}{F_(13)}, used to initiate the EM alg.}

\item{lambda}{Initial values for \eqn{\Lambda_{23}}{Lambda_(23)}, used to initiate the EM alg.}

\item{tol}{Tolerance of the EM algorithm. When the change in sum(abs(z)) and 
sum(abs(lambda)) no longer exceeds tol, the algorithm stops.}
}
\value{
beta: Indicator whether Q subset A
mu: Value used in the EM algorithm, see Frydman (1995) and Notes.
I_Q_in_Lm_tn_star: Indicator whether Q is in [L_m, t_n^*]
gamma: Value used in the EM algorithm, see Frydman (1995) and Notes.
alpha: Indicator whether Q subset [s_j, Infinity)
mu_overline: Value used in the EM algorithm, see Frydman (1995) and Notes.
lambda: Intensity for the 2->3 transition
z: Mass assigned to the 1->2 and 1->3 transitions
iter: Number of iterations required for convergence
}
\description{
Solves for the cdf and transition intensities using the EM 
algorithm described in Frydman (1995).
}
\references{
Frydman, H. (1995). Nonparametric Estimation of a Markov 
'Illness-Death' Process from Interval- Censored Observations, with 
Application to Diabetes Survival Data. Biometrika, 82(4), 773-789. 
\doi{10.2307/2337344}
}
\keyword{internal}
