% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-spherical.R
\name{arcs}
\alias{arcs}
\alias{arcs,matrix-method}
\alias{arcs,data.frame-method}
\title{Function to plot a set of great circle arcs between points}
\usage{
arcs(x, ...)

\S4method{arcs}{matrix}(x, breaks = 100, breakAtDateline = TRUE, plot = TRUE, ...)

\S4method{arcs}{data.frame}(x, ...)
}
\arguments{
\item{x}{A matrix of longitude and latitude points (WGS 84 longlat)}

\item{...}{Arguments passed to lines (par)}

\item{breaks}{the number of points inserted between every points to draw great circle arcs.}

\item{breakAtDateline}{Logical to indicate whether the lines are to be broken at the dateline.}

\item{plot}{Logical value whether the plotting should be done at all (in case returned values are needed).}
}
\value{
Invisible return of a matrix of coordinates. If \code{breakAtDateline = TRUE}, then \code{NA} missing values
will be inserted between coordinates where the lines cross the dateline.
}
\description{
Low level plotting of great circle arcs with lines
}
\examples{
# generate random points
set.seed(0)
example <- rpsphere(10, output="polar")

# plotting
plot(NULL, NULL, xlim=c(-180, 180), ylim=c(-90,90))
points(example)
text(label=1:nrow(example), example, pos=2)
arcs(example, col="red", breaks=200)
}
