% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bases.R
\name{bbase}
\alias{bbase}
\title{Compute a B-spline basis}
\usage{
bbase(x, xl = min(x), xr = max(x), nseg = 10, deg = 3)
}
\arguments{
\item{x}{The vector of values for which the basis is to be evaluated}

\item{xl}{The left boundary of the domain}

\item{xr}{The right boundary of the domain}

\item{nseg}{The number of inter-knot segments on the domain}

\item{deg}{The degree of the B-splines (2 means quadratic, 3 means cubic, and so on)}
}
\value{
A matrix containing the basis
}
\description{
Compute a B-spline basis
}
\examples{
x = runif(100)
B = bbase(x, 0, 1, 20, 3)
}
