% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sobelTest_one}
\alias{sobelTest_one}
\title{Sobel test for the indirect effect - Single mediator path}
\usage{
sobelTest_one(
  mu1,
  sig1,
  mu2,
  sig2,
  sig12,
  indL = 1,
  mu3 = 0L,
  sig3 = 0L,
  sig13 = 0L,
  sig23 = 0L,
  mu1_0 = 0,
  mu2_0 = 0,
  mu3_0 = 0
)
}
\arguments{
\item{mu1}{Value of the estimate of the independent variable on the mediator.}

\item{sig1}{Value of the variance of the estimate of the independent variable on the mediator.}

\item{mu2}{Value of the estimate of the mediator on the response.}

\item{sig2}{Value of the variance of the estimate of the mediator on the response.}

\item{sig12}{Value of the covariance between mu1 and mu2.}

\item{indL}{Value indicating the value of the independent variable used for the interaction. Typically 1.}

\item{mu3}{Value of the estimate of the effect of the interaction of the independent and mediator variable on the response.}

\item{sig3}{Value of the variance of the estimate of the effect of the interaction of the independent and mediator variable on the response.}

\item{sig13}{Value of the covariance between mu1 and mu3.}

\item{sig23}{Value of the covariance between mu2 and mu3.}

\item{mu1_0}{Null value for mu1.}

\item{mu2_0}{Null value for mu2.}

\item{mu3_0}{Null value for mu3.}
}
\value{
A p-value for the test for the indirect effect.
}
\description{
This function takes the parameter estimates and covariances
and performs the Sobel test for one mediator, or a single
mediator path for multiple unordered mediators.
}
\examples{
sobelTest_one(1, .1, .25, .01, .05)
}
