% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sobelTest_ord}
\alias{sobelTest_ord}
\title{Sobel test for the indirect effect - Two ordered mediator path}
\usage{
sobelTest_ord(
  mu1,
  sig1,
  mu2,
  sig2,
  mu3,
  sig3,
  mu2b = 0L,
  sig2b = 0L,
  mu3b = 0L,
  sig3b = 0L,
  sig12 = 0L,
  sig12b = 0L,
  sig13 = 0L,
  sig13b = 0L,
  sig22b = 0L,
  sig23 = 0L,
  sig23b = 0L,
  sig2b3 = 0L,
  sig2b3b = 0L,
  sig33b = 0L,
  indL = 1L,
  mu1_0 = 0,
  mu2_0 = 0,
  mu3_0 = 0,
  mu2b_0 = 0,
  mu3b_0 = 0
)
}
\arguments{
\item{mu1}{Value of the estimate of the independent variable on the first mediator.}

\item{sig1}{Value of the variance of the estimate of the independent variable on the first mediator.}

\item{mu2}{Value of the estimate of the first mediator on the second mediator.}

\item{sig2}{Value of the variance of the estimate of the first mediator on the second mediator.}

\item{mu3}{Value of the estimate of the second mediator on the response.}

\item{sig3}{Value of the variance of the estimate of the second mediator on the response.}

\item{mu2b}{Value of the estimate of the effect of the interaction of the independent and first mediator variable on the second mediator.}

\item{sig2b}{Value of the variance of the estimate of the effect of the interaction of the independent and first mediator variable on the second mediator.}

\item{mu3b}{Value of the estimate of the effect of the interaction of the independent and second mediator variable on the response.}

\item{sig3b}{Value of the variance of the estimate of the effect of the interaction of the independent and second mediator variable on the response.}

\item{sig12}{Value of the covariance between mu1 and mu2.}

\item{sig12b}{Value of the covariance between mu1 and mu2b.}

\item{sig13}{Value of the covariance between mu1 and mu3.}

\item{sig13b}{Value of the covariance between mu1 and mu3b.}

\item{sig22b}{Value of the covariance between mu2 and mu2b.}

\item{sig23}{Value of the covariance between mu2 and mu3.}

\item{sig23b}{Value of the covariance between mu2 and mu2b.}

\item{sig2b3}{Value of the covariance between mu2b and mu3.}

\item{sig2b3b}{Value of the covariance between mu2b and mu3b.}

\item{sig33b}{Value of the covariance between mu3 and mu3b.}

\item{indL}{Value indicating the value of the independent variable used for the interaction. Typically 1.}

\item{mu1_0}{Null value for mu1.}

\item{mu2_0}{Null value for mu2.}

\item{mu3_0}{Null value for mu3.}

\item{mu2b_0}{Null value for mu2b.}

\item{mu3b_0}{Null value for mu3b.}
}
\value{
A p-value for the test for the indirect effect.
}
\description{
This function takes the parameter estimates and covariances
and performs the Sobel test for two ordered mediators.
}
\examples{
sobelTest_ord(1, .1, .25, .01, 0, 0, .15, .01, 0, 0)
}
