#include <RcppArmadillo.h>
#include "ieTest.h"
using namespace Rcpp;

// Function not needed by R

// Function takes a vector of parameter values, a vector of null values,
// and a matrix for the covariance matrix

// Function returns a matrix with 2 columns, where the first is the new parameter 
// to be tested, and the second are the new null values
// If the null values are 0, they will remain at zero. 
// Resulting parameter values are independent with SE = 1


arma::mat corrTrans(arma::vec meanVector, arma::vec nullVector, arma::mat sigma){
  arma::mat cholM = arma::zeros(sigma.n_rows, sigma.n_cols);
  bool cholW = chol(cholM, sigma, "lower");
  arma::mat toReturn = arma::zeros(meanVector.n_elem, 2);
  if(cholW){
    arma::mat decomp = arma::inv(cholM);
    
    arma::vec newMeans = decomp * meanVector;
    arma::vec newNull = decomp * nullVector;
    
    toReturn.col(0) = newMeans;
    toReturn.col(1) = newNull;
  }else{
    Rcout << "Covariance matrix is not positive-definite. \n";  
  }
    
  return toReturn;
}
